/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.analyse;

import de.neemann.digital.analyse.expression.ComplexityVisitor;
import de.neemann.digital.analyse.expression.Constant;
import de.neemann.digital.analyse.expression.Expression;
import de.neemann.digital.analyse.expression.ExpressionException;
import de.neemann.digital.analyse.expression.Not;
import de.neemann.digital.analyse.expression.Operation;
import de.neemann.digital.analyse.expression.Variable;
import de.neemann.digital.analyse.quinemc.QuineMcCluskey;
import de.neemann.digital.lang.Lang;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DetermineJKStateMachine {
    private Expression j = null;
    private Expression nk = null;
    private Expression simpj = null;
    private Expression simpk = null;
    private boolean isDFF;

    public DetermineJKStateMachine(String name, Expression e) throws ExpressionException {
        Variable var = new Variable(name);
        Expression notVar = Not.not(var);
        boolean wasK = false;
        boolean wasJ = false;
        for (Expression or : this.getOrs(e)) {
            Expression term = null;
            boolean belongsToK = false;
            boolean belongsToJ = false;
            for (Expression expression : this.getAnds(or)) {
                if (expression.equals(var)) {
                    belongsToK = true;
                    wasK = true;
                    continue;
                }
                if (expression.equals(notVar)) {
                    belongsToJ = true;
                    wasJ = true;
                    continue;
                }
                term = Operation.and(term, expression);
            }
            if (belongsToJ && belongsToK) {
                throw new ExpressionException(Lang.get("err_containsVarAndNotVar", new Object[0]));
            }
            if (belongsToJ) {
                if (term == null) {
                    term = Constant.ONE;
                }
                this.j = Operation.or(term, this.j);
                continue;
            }
            if (belongsToK) {
                if (term == null) {
                    term = Constant.ONE;
                }
                this.nk = Operation.or(term, this.nk);
                continue;
            }
            this.j = Operation.or(term, this.j);
            this.nk = Operation.or(term, this.nk);
        }
        if (this.j == null) {
            this.j = wasJ ? Constant.ONE : Constant.ZERO;
        }
        if (this.nk == null) {
            this.nk = wasK ? Constant.ONE : Constant.ZERO;
        }
        this.isDFF = !wasJ && !wasK;
    }

    public int getComplexity() throws ExpressionException {
        return this.getSimplifiedJ().traverse(new ComplexityVisitor()).getComplexity() + this.getSimplifiedK().traverse(new ComplexityVisitor()).getComplexity();
    }

    private Iterable<Expression> getOrs(Expression e) {
        if (e instanceof Operation.Or) {
            return ((Operation.Or)e).getExpressions();
        }
        return new AsIterable<Expression>(e);
    }

    private Iterable<? extends Expression> getAnds(Expression e) {
        if (e instanceof Operation.And) {
            return ((Operation.And)e).getExpressions();
        }
        return new AsIterable(e);
    }

    public Expression getJ() {
        return this.j;
    }

    public Expression getNK() {
        return this.nk;
    }

    public Expression getK() {
        return Not.not(this.nk);
    }

    public boolean isDFF() {
        return this.isDFF;
    }

    public Expression getSimplifiedJ() throws ExpressionException {
        if (this.simpj == null) {
            this.simpj = QuineMcCluskey.simplify(this.getJ());
        }
        return this.simpj;
    }

    public Expression getSimplifiedK() throws ExpressionException {
        if (this.simpk == null) {
            this.simpk = QuineMcCluskey.simplify(this.getK());
        }
        return this.simpk;
    }

    private static final class AsIterable<T>
    implements Iterable<T> {
        private final T item;

        private AsIterable(T item) {
            this.item = item;
        }

        @Override
        public Iterator<T> iterator() {
            return new SingleItemIterator(this.item);
        }

        private static final class SingleItemIterator<T>
        implements Iterator<T> {
            private T item;

            private SingleItemIterator(T item) {
                this.item = item;
            }

            @Override
            public boolean hasNext() {
                return this.item != null;
            }

            @Override
            public T next() {
                if (this.item == null) {
                    throw new NoSuchElementException();
                }
                T ee = this.item;
                this.item = null;
                return ee;
            }

            @Override
            public void remove() {
            }
        }
    }
}

