/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.analyse;

import de.neemann.digital.analyse.MinimizerQuineMcCluskey;
import de.neemann.digital.analyse.expression.ComplexityVisitor;
import de.neemann.digital.analyse.expression.Expression;
import de.neemann.digital.analyse.expression.ExpressionException;
import de.neemann.digital.analyse.expression.Variable;
import de.neemann.digital.analyse.expression.format.FormatterException;
import de.neemann.digital.analyse.quinemc.BoolTable;
import de.neemann.digital.analyse.quinemc.QuineMcCluskey;
import de.neemann.digital.analyse.quinemc.QuineMcCluskeyExam;
import de.neemann.digital.gui.components.table.ExpressionListener;
import java.util.ArrayList;
import java.util.List;

public class MinimizerQuineMcCluskeyExam
extends MinimizerQuineMcCluskey {
    @Override
    public void minimize(List<Variable> vars, BoolTable boolTable, String resultName, ExpressionListener listener) throws ExpressionException, FormatterException {
        ExpressionListenerEnsureMinimal l = new ExpressionListenerEnsureMinimal(listener);
        super.minimize(vars, boolTable, resultName, l);
        l.close();
    }

    @Override
    protected QuineMcCluskey createQuineMcCluskey(List<Variable> vars) {
        return new QuineMcCluskeyExam(vars);
    }

    private static final class ExpressionListenerEnsureMinimal
    implements ExpressionListener {
        private final ExpressionListener parent;
        private String lastName;
        private ArrayList<Expression> list;
        private int complexity;

        private ExpressionListenerEnsureMinimal(ExpressionListener parent) {
            this.parent = parent;
            this.list = new ArrayList();
        }

        @Override
        public void resultFound(String name, Expression expression) throws FormatterException, ExpressionException {
            int comp;
            if (!name.equals(this.lastName)) {
                for (Expression e : this.list) {
                    this.parent.resultFound(this.lastName, e);
                }
                this.list.clear();
                this.complexity = Integer.MAX_VALUE;
                this.lastName = name;
            }
            if ((comp = expression.traverse(new ComplexityVisitor()).getComplexity()) < this.complexity) {
                this.list.clear();
                this.complexity = comp;
            }
            this.list.add(expression);
        }

        @Override
        public void close() throws FormatterException, ExpressionException {
            for (Expression e : this.list) {
                this.parent.resultFound(this.lastName, e);
            }
        }
    }
}

