/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.analyse.expression;

import de.neemann.digital.analyse.expression.BitSetter;
import de.neemann.digital.analyse.expression.ContextMap;
import de.neemann.digital.analyse.expression.Expression;
import de.neemann.digital.analyse.expression.Variable;
import de.neemann.digital.analyse.expression.VariableVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ContextFiller
extends ContextMap
implements Iterable<Variable> {
    private final List<Variable> vars;
    private final int rowCount;
    private final BitSetter bitSetter;

    public ContextFiller(Expression expression) {
        this(new ArrayList<Variable>(expression.traverse(new VariableVisitor()).getVariables()));
        Collections.sort(this.vars);
    }

    public ContextFiller(Variable ... variables) {
        this(Arrays.asList(variables));
    }

    public ContextFiller(List<Variable> variables) {
        this.vars = variables;
        this.rowCount = 1 << this.vars.size();
        this.bitSetter = new BitSetter(this.vars.size()){

            @Override
            public void setBit(int row, int i, boolean value) {
                ContextFiller.this.set((Variable)ContextFiller.this.vars.get(i), value);
            }
        };
    }

    @Override
    public Iterator<Variable> iterator() {
        return this.vars.iterator();
    }

    public Variable getVar(int index) {
        return this.vars.get(index);
    }

    public int getVarCount() {
        return this.vars.size();
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public ContextFiller setContextTo(int bitValue) {
        this.bitSetter.fill(bitValue);
        return this;
    }

    public List<Variable> getVariables() {
        return this.vars;
    }
}

