/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.builder;

import de.neemann.digital.analyse.expression.Expression;
import de.neemann.digital.analyse.expression.Variable;
import de.neemann.digital.analyse.expression.VariableVisitor;
import de.neemann.digital.builder.BuilderException;
import de.neemann.digital.builder.BuilderInterface;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

public class BuilderCollector
implements BuilderInterface<BuilderCollector> {
    private final VariableVisitor vars = new VariableVisitor();
    private ArrayList<String> outputs = new ArrayList();
    private TreeMap<String, Expression> combinatorial = new TreeMap();
    private TreeMap<String, Expression> registered = new TreeMap();

    @Override
    public BuilderCollector addCombinatorial(String name, Expression expression) throws BuilderException {
        expression.traverse(this.vars);
        this.outputs.add(name);
        this.combinatorial.put(name, expression);
        return this;
    }

    @Override
    public BuilderCollector addSequential(String name, Expression expression) throws BuilderException {
        expression.traverse(this.vars);
        this.outputs.add(name);
        this.registered.put(name, expression);
        return this;
    }

    public ArrayList<String> getOutputs() {
        return this.outputs;
    }

    public ArrayList<String> getInputs() {
        ArrayList<String> inputs = new ArrayList<String>();
        for (Variable v : this.vars.getVariables()) {
            if (this.outputs.contains(v.getIdentifier())) continue;
            inputs.add(v.getIdentifier());
        }
        return inputs;
    }

    public Map<String, Expression> getCombinatorial() {
        return this.combinatorial;
    }

    public Map<String, Expression> getRegistered() {
        return this.registered;
    }

    public void removeOutput(String name) {
        this.outputs.remove(name);
    }
}

