/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.builder;

import de.neemann.digital.analyse.expression.Expression;
import de.neemann.digital.analyse.expression.Variable;
import de.neemann.digital.builder.PinMapException;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.lang.Lang;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;

public class PinMap {
    private final HashMap<String, Integer> pinMap = new HashMap();
    private final ArrayList<Pin> availPins;
    private ArrayList<HashSet<String>> alias = new ArrayList();
    private int clockPin;

    public PinMap() {
        this.availPins = new ArrayList();
    }

    public PinMap setAvailInputs(int ... inputPins) {
        int[] nArray = inputPins;
        int n = inputPins.length;
        int n2 = 0;
        while (n2 < n) {
            int p = nArray[n2];
            this.availPins.add(new Pin(p, PinDescription.Direction.input));
            ++n2;
        }
        return this;
    }

    public PinMap setAvailOutputs(int ... outputPins) {
        int[] nArray = outputPins;
        int n = outputPins.length;
        int n2 = 0;
        while (n2 < n) {
            int p = nArray[n2];
            this.availPins.add(new Pin(p, PinDescription.Direction.output));
            ++n2;
        }
        return this;
    }

    public PinMap setAvailBidirectional(int ... outputPins) {
        int[] nArray = outputPins;
        int n = outputPins.length;
        int n2 = 0;
        while (n2 < n) {
            int p = nArray[n2];
            this.availPins.add(new Pin(p, PinDescription.Direction.both));
            ++n2;
        }
        return this;
    }

    public PinMap assignPin(String name, int pin) throws PinMapException {
        if (name == null || name.length() == 0) {
            throw new PinMapException(Lang.get("err_pinMap_NoNameForPin_N", pin));
        }
        if (this.pinMap.containsKey(name)) {
            throw new PinMapException(Lang.get("err_pinMap_Pin_N_AssignedTwicePin", name));
        }
        if (this.pinMap.containsValue(pin)) {
            throw new PinMapException(Lang.get("err_pinMap_Pin_N_AssignedTwicePin", pin));
        }
        this.pinMap.put(name, pin);
        return this;
    }

    public PinMap parseString(String assignment) throws PinMapException {
        if (assignment == null) {
            return this;
        }
        StringTokenizer st = new StringTokenizer(assignment, ";,");
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            int p = tok.indexOf("=");
            if (p < 0) {
                throw new PinMapException(Lang.get("err_pinMap_noEqualsfound", new Object[0]));
            }
            String name = tok.substring(0, p).trim();
            String numStr = tok.substring(p + 1).trim();
            try {
                int num = Integer.parseInt(numStr);
                this.assignPin(name, num);
            }
            catch (NumberFormatException e) {
                throw new PinMapException(e);
            }
        }
        return this;
    }

    public boolean isSimpleAlias(String name, Expression expression, HashSet<String> sequentialVars) {
        if (expression instanceof Variable) {
            String al = ((Variable)expression).getIdentifier();
            if (sequentialVars != null && !sequentialVars.contains(al)) {
                return false;
            }
            HashSet<String> found = null;
            for (HashSet<String> s : this.alias) {
                if (!s.contains(name) && !s.contains(al)) continue;
                found = s;
                break;
            }
            if (found == null) {
                found = new HashSet<String>();
                this.alias.add(found);
            }
            found.add(name);
            found.add(al);
            return true;
        }
        return false;
    }

    public PinMap addAll(Map<String, String> pinMap) throws PinMapException {
        if (pinMap != null) {
            for (Map.Entry<String, String> e : pinMap.entrySet()) {
                try {
                    this.assignPin(e.getKey(), Integer.parseInt(e.getValue()));
                }
                catch (NumberFormatException ex) {
                    throw new PinMapException(Lang.get("err_pinIsNotANumber_N", e.getValue()));
                }
            }
        }
        return this;
    }

    private Integer searchFirstFreePin(PinDescription.Direction direction, String name) {
        for (Pin pin : this.availPins) {
            if (this.pinMap.containsValue(pin.num) || !pin.direction.equals((Object)direction) && !pin.direction.equals((Object)PinDescription.Direction.both)) continue;
            this.pinMap.put(name, pin.num);
            return pin.num;
        }
        return null;
    }

    private boolean isAvailable(PinDescription.Direction direction, int p) {
        for (Pin pin : this.availPins) {
            if (pin.num != p) continue;
            return pin.direction.equals((Object)direction) || pin.direction.equals((Object)PinDescription.Direction.both);
        }
        return false;
    }

    public int getInputFor(String in) throws PinMapException {
        return this.getPinFor(in, PinDescription.Direction.input);
    }

    public int isOutputAssigned(String in) throws PinMapException {
        Integer p = this.searchPinWithAlias(in);
        if (p == null) {
            return -1;
        }
        if (!this.isAvailable(PinDescription.Direction.output, p)) {
            throw new PinMapException(Lang.get("err_pinMap_pin_N0_isNotAnOutput", p));
        }
        return p;
    }

    private int getPinFor(String in, PinDescription.Direction direction) throws PinMapException {
        Integer p = this.searchPinWithAlias(in);
        if (p == null) {
            p = this.searchFirstFreePin(direction, in);
        }
        if (p == null) {
            if (direction.equals((Object)PinDescription.Direction.input)) {
                throw new PinMapException(Lang.get("err_pinMap_toMannyInputsDefined", new Object[0]));
            }
            throw new PinMapException(Lang.get("err_pinMap_toMannyOutputsDefined", new Object[0]));
        }
        if (!this.isAvailable(direction, p)) {
            if (direction.equals((Object)PinDescription.Direction.input)) {
                throw new PinMapException(Lang.get("err_pinMap_pin_N0_isNotAnInput", p));
            }
            throw new PinMapException(Lang.get("err_pinMap_pin_N0_isNotAnOutput", p));
        }
        return p;
    }

    private Integer searchPinWithAlias(String pinName) {
        for (HashSet<String> aliasSet : this.alias) {
            if (!aliasSet.contains(pinName)) continue;
            for (String n : aliasSet) {
                Integer p = this.pinMap.get(n);
                if (p == null) continue;
                return p;
            }
        }
        return this.pinMap.get(pinName);
    }

    public int getOutputFor(String out) throws PinMapException {
        return this.getPinFor(out, PinDescription.Direction.output);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Lang.get("msg_pins", new Object[0])).append(":\n");
        for (Map.Entry<String, Integer> p : this.pinMap.entrySet()) {
            sb.append(Lang.get("msg_pinMap_pin_N_is_N", p.getValue(), p.getKey())).append("\n");
        }
        return sb.toString();
    }

    public int getClockPin() {
        return this.clockPin;
    }

    public PinMap setClockPin(int clockPin) {
        if (clockPin > 0) {
            this.clockPin = clockPin;
        }
        return this;
    }

    private static final class Pin {
        private final int num;
        private final PinDescription.Direction direction;

        private Pin(int num, PinDescription.Direction direction) {
            this.num = num;
            this.direction = direction;
        }
    }
}

