/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.builder.jedec;

public class FuseMap {
    private final int fuses;
    private final byte[] fuseData;

    public FuseMap(int fuses) {
        this.fuses = fuses;
        this.fuseData = new byte[(fuses - 1) / 8 + 1];
    }

    public int getFuses() {
        return this.fuses;
    }

    public void setFuse(int fuse) {
        this.setFuse(fuse, true);
    }

    public void setFuse(int fuse, boolean set) {
        int index = fuse >> 3;
        int n = fuse & 7;
        int mask = 1 << n;
        if (set) {
            int n2 = index;
            this.fuseData[n2] = (byte)(this.fuseData[n2] | mask);
        } else {
            int n3 = index;
            this.fuseData[n3] = (byte)(this.fuseData[n3] & ~mask);
        }
    }

    public boolean getFuse(int fuse) {
        int index = fuse >> 3;
        int n = fuse & 7;
        int mask = 1 << n;
        return (this.fuseData[index] & mask) != 0;
    }

    public int getJedecChecksum() {
        int c = 0;
        int i = 0;
        while (i < this.fuseData.length) {
            c += this.fuseData[i] & 0xFF;
            ++i;
        }
        return c & 0xFFFF;
    }

    byte[] getFuseData() {
        return this.fuseData;
    }
}

