/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.builder.jedec;

import de.neemann.digital.analyse.expression.Expression;
import de.neemann.digital.analyse.expression.Not;
import de.neemann.digital.analyse.expression.Operation;
import de.neemann.digital.analyse.expression.Variable;
import de.neemann.digital.builder.jedec.FuseMap;
import de.neemann.digital.builder.jedec.FuseMapFillerException;
import java.util.ArrayList;
import java.util.HashMap;

public class FuseMapFiller {
    private final FuseMap fuseMap;
    private final int varsConnectedToMap;
    private final HashMap<Variable, MapEntry> varMap;

    public FuseMapFiller(FuseMap fuseMap, int varsConnectedToMap) {
        this.fuseMap = fuseMap;
        this.varsConnectedToMap = varsConnectedToMap;
        this.varMap = new HashMap();
    }

    public FuseMapFiller addVariable(int index, Variable var) {
        this.varMap.put(var, new MapEntry(index, false));
        return this;
    }

    public FuseMapFiller addVariableReverse(int index, Variable var) {
        this.varMap.put(var, new MapEntry(index, true));
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void fillExpression(int offs, Expression exp, int productTerms) throws FuseMapFillerException {
        ArrayList<Object> terms;
        if (exp instanceof Operation.Or) {
            Operation.Or or = (Operation.Or)exp;
            terms = or.getExpressions();
        } else {
            terms = new ArrayList<Expression>();
            terms.add(exp);
        }
        if (terms.size() > productTerms) {
            throw new FuseMapFillerException("only " + productTerms + " product terms supported but " + terms.size() + " needed!");
        }
        int fusesInTerm = this.varsConnectedToMap * 2;
        for (Expression expression : terms) {
            ArrayList<Expression> ands;
            int i = 0;
            while (i < fusesInTerm) {
                this.fuseMap.setFuse(offs + i, true);
                ++i;
            }
            if (expression instanceof Operation.And) {
                ands = ((Operation.And)expression).getExpressions();
            } else {
                ands = new ArrayList();
                ands.add(expression);
            }
            for (Expression v : ands) {
                Variable var;
                boolean invert = false;
                if (v instanceof Variable) {
                    var = (Variable)v;
                } else {
                    if (!(v instanceof Not)) throw new FuseMapFillerException("only VAR or NOT VAR allowed!");
                    Expression n = ((Not)v).getExpression();
                    if (!(n instanceof Variable)) throw new FuseMapFillerException("NOT does not contain a variable!");
                    var = (Variable)n;
                    invert = true;
                }
                MapEntry entry = this.varMap.get(var);
                if (entry == null) {
                    throw new FuseMapFillerException("VAR " + var + " not found in term list!");
                }
                int fuse = entry.getFuse(invert);
                this.fuseMap.setFuse(offs + fuse, false);
            }
            offs += fusesInTerm;
        }
    }

    private static class MapEntry {
        private final int index;
        private final boolean swap;

        MapEntry(int index, boolean swap) {
            this.index = index;
            this.swap = swap;
        }

        int getFuse(boolean invert) {
            int fuse = this.index * 2;
            if (this.swap) {
                if (!invert) {
                    ++fuse;
                }
            } else if (invert) {
                ++fuse;
            }
            return fuse;
        }
    }
}

