/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.builder.tt2;

import de.neemann.digital.analyse.expression.Constant;
import de.neemann.digital.analyse.expression.Expression;
import de.neemann.digital.analyse.expression.Not;
import de.neemann.digital.analyse.expression.Operation;
import de.neemann.digital.analyse.expression.Variable;
import de.neemann.digital.builder.BuilderCollector;
import de.neemann.digital.builder.BuilderInterface;
import de.neemann.digital.builder.CleanNameBuilder;
import de.neemann.digital.builder.ExpressionExporter;
import de.neemann.digital.builder.PinMap;
import de.neemann.digital.builder.PinMapException;
import de.neemann.digital.builder.jedec.FuseMapFillerException;
import de.neemann.digital.lang.Lang;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class TT2Exporter
implements ExpressionExporter<TT2Exporter> {
    private final BuilderCollector builder = new BuilderCollector();
    private final CleanNameBuilder cleanNameBuilder = new CleanNameBuilder(this.builder);
    private final PinMap pinMap = this.cleanNameBuilder.createPinMap().setClockPin(43);
    private String projectName;
    private String device = "f1502ispplcc44";
    private OutputStreamWriter writer;
    private HashMap<String, Integer> varIndexMap;
    private HashMap<String, Integer> outIndexMap;
    private TreeMap<ProdInput, StateSet> termMap;
    private ArrayList<String> inputs;
    private ArrayList<String> outputs;
    private StateSet constants;
    private boolean constantsUsed = false;

    public TT2Exporter(String projectName) {
        this.projectName = projectName;
    }

    @Override
    public BuilderInterface getBuilder() {
        return this.cleanNameBuilder;
    }

    public TT2Exporter setDevice(String device) {
        this.device = device;
        return this;
    }

    @Override
    public PinMap getPinMapping() {
        return this.pinMap;
    }

    @Override
    public void writeTo(OutputStream out) throws FuseMapFillerException, IOException, PinMapException {
        this.writeTo(new OutputStreamWriter(out, StandardCharsets.ISO_8859_1));
    }

    private void writeTo(OutputStreamWriter writer) throws IOException, FuseMapFillerException, PinMapException {
        this.createProductTerms();
        this.writer = writer;
        this.line("#$ TOOL CUPL");
        this.line("# Berkeley PLA format generated using Digital");
        this.line("#$ TITLE  " + this.projectName);
        this.line("#$ DEVICE  " + this.device);
        this.assignPinsAndNodes();
        this.line(".i " + this.inputs.size());
        this.line(".o " + this.outputs.size());
        this.line(".type f");
        if (this.inputs.size() > 0) {
            this.line(".ilb " + this.strList(this.inputs));
        }
        this.line(".ob " + this.strList(this.outputs));
        this.line(".phase " + this.getPhase());
        this.line(".p " + this.termMap.size());
        for (Map.Entry<ProdInput, StateSet> e : this.termMap.entrySet()) {
            this.line(e.getKey() + " " + e.getValue());
        }
        this.line(".e");
        writer.close();
    }

    private void createProductTerms() throws FuseMapFillerException {
        this.inputs = this.builder.getInputs();
        this.varIndexMap = new HashMap();
        int i = 0;
        for (String name : this.inputs) {
            TT2Exporter.checkName(name);
            this.varIndexMap.put(name, i);
            ++i;
        }
        ProdInput clkIn = null;
        if (!this.builder.getRegistered().isEmpty()) {
            int clk = this.inputs.size();
            this.inputs.add("CLK");
            this.varIndexMap.put("CLK", i);
            ++i;
            for (String reg : this.builder.getRegistered().keySet()) {
                this.inputs.add(String.valueOf(reg) + ".Q");
                this.varIndexMap.put(reg, i);
                ++i;
            }
            clkIn = new ProdInput(this.inputs.size());
            clkIn.set(clk, 1);
        }
        ArrayList<Integer> clkInList = new ArrayList<Integer>();
        this.outputs = new ArrayList();
        this.outIndexMap = new HashMap();
        i = 0;
        for (String name : this.builder.getOutputs()) {
            TT2Exporter.checkName(name);
            if (this.builder.getRegistered().containsKey(name)) {
                this.outIndexMap.put(String.valueOf(name) + ".REG", i++);
                this.outputs.add(String.valueOf(name) + ".REG");
                this.outIndexMap.put(String.valueOf(name) + ".AR", i++);
                this.outputs.add(String.valueOf(name) + ".AR");
                clkInList.add(i);
                this.outIndexMap.put(String.valueOf(name) + ".C", i++);
                this.outputs.add(String.valueOf(name) + ".C");
                continue;
            }
            this.outIndexMap.put(name, i++);
            this.outputs.add(name);
        }
        this.termMap = new TreeMap();
        if (!this.builder.getRegistered().isEmpty()) {
            StateSet clk = new StateSet(this.outputs.size(), null, null);
            Iterator<Object> iterator = clkInList.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                clk.set(n, 1);
            }
            this.termMap.put(clkIn, clk);
            this.constantsUsed = true;
        }
        this.constants = new StateSet(this.outputs.size(), null, null);
        ProdInput constProdInput = new ProdInput(this.inputs.size());
        this.termMap.put(constProdInput, this.constants);
        for (Map.Entry entry : this.builder.getCombinatorial().entrySet()) {
            this.addExpression((String)entry.getKey(), (Expression)entry.getValue());
        }
        for (Map.Entry entry : this.builder.getRegistered().entrySet()) {
            this.addExpression(String.valueOf((String)entry.getKey()) + ".REG", (Expression)entry.getValue());
        }
        if (!this.constantsUsed) {
            this.termMap.remove(constProdInput);
        }
    }

    static void checkName(String name) throws FuseMapFillerException {
        if (name.length() == 0) {
            throw new FuseMapFillerException(Lang.get("err_invalidPinName_N", name));
        }
        char first = name.charAt(0);
        if (first >= '0' && first <= '9') {
            throw new FuseMapFillerException(Lang.get("err_invalidPinName_N", name));
        }
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_')) {
                throw new FuseMapFillerException(Lang.get("err_invalidPinName_N", name));
            }
            ++i;
        }
    }

    private void addExpression(String name, Expression expression) throws FuseMapFillerException {
        if (expression instanceof Operation.Or) {
            Operation.Or or = (Operation.Or)expression;
            for (Expression e : or.getExpressions()) {
                this.addProdFor(name, e);
            }
        } else if (expression instanceof Constant) {
            this.constantsUsed = true;
            if (expression == Constant.ONE) {
                this.constants.set(this.getOutNum(name));
            }
        } else {
            this.addProdFor(name, expression);
        }
    }

    private void addProdFor(String name, Expression e) throws FuseMapFillerException {
        ProdInput pt = new ProdInput(this.getInputCount());
        if (e instanceof Operation.And) {
            Operation.And and = (Operation.And)e;
            for (Expression z : and.getExpressions()) {
                pt.add(z);
            }
        } else {
            pt.add(e);
        }
        StateSet o = this.termMap.computeIfAbsent(pt, k -> new StateSet(this.getOutputCount(), null, null));
        o.set(this.getOutNum(name));
    }

    private String strList(ArrayList<String> pins) {
        StringBuilder sb = new StringBuilder();
        for (String p : pins) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(p);
        }
        return sb.toString();
    }

    private void line(String s) throws IOException {
        this.writer.write(s);
        this.writer.write("\r\n");
    }

    private int getInputCount() {
        return this.varIndexMap.size();
    }

    private int getVarNum(String identifier) throws FuseMapFillerException {
        Integer i = this.varIndexMap.get(identifier);
        if (i == null) {
            throw new FuseMapFillerException("ident " + identifier + " not found!");
        }
        return i;
    }

    private int getOutputCount() {
        return this.outIndexMap.size();
    }

    private int getOutNum(String identifier) {
        return this.outIndexMap.get(identifier);
    }

    private String getPhase() {
        StringBuilder sb = new StringBuilder(this.getOutputCount());
        int i = 0;
        while (i < this.getOutputCount()) {
            sb.append("1");
            ++i;
        }
        return sb.toString();
    }

    private void assignPinsAndNodes() throws IOException, PinMapException {
        int p;
        int pinNum = 0;
        StringBuilder pin = new StringBuilder();
        int nodeNum = 0;
        StringBuilder node = new StringBuilder();
        for (String i : this.builder.getInputs()) {
            p = this.pinMap.getInputFor(i);
            pin.append(" ").append(i).append("+:").append(p);
            ++pinNum;
        }
        if (!this.builder.getRegistered().isEmpty()) {
            pin.append(" CLK+:").append(this.pinMap.getClockPin());
            ++pinNum;
        }
        for (String o : this.builder.getOutputs()) {
            p = this.pinMap.isOutputAssigned(o);
            if (p >= 0) {
                pin.append(" ").append(o).append("+:").append(p);
                ++pinNum;
                continue;
            }
            node.append(" ").append(o);
            ++nodeNum;
        }
        if (pinNum > 0) {
            this.line("#$ PINS " + pinNum + pin.toString());
        }
        if (nodeNum > 0) {
            this.line("#$ NODES " + nodeNum + node.toString());
        }
    }

    private final class ProdInput
    extends StateSet {
        private ProdInput(int inputCount) {
            super(inputCount);
            this.setAllToUnused();
        }

        public void add(Expression z) throws FuseMapFillerException {
            if (z instanceof Not) {
                this.add(((Not)z).getExpression(), true);
            } else {
                this.add(z, false);
            }
        }

        private void add(Expression var, boolean invers) throws FuseMapFillerException {
            if (!(var instanceof Variable)) {
                if (var instanceof Constant) {
                    throw new FuseMapFillerException(Lang.get("err_constantsNotAllowed", new Object[0]));
                }
                throw new FuseMapFillerException("invalid expression");
            }
            this.set(TT2Exporter.this.getVarNum(((Variable)var).getIdentifier()), invers ? 0 : 1);
        }
    }

    private static class StateSet
    implements Comparable<StateSet> {
        private final int[] state;

        private StateSet(int outputCount) {
            this.state = new int[outputCount];
        }

        void setAllToUnused() {
            Arrays.fill(this.state, 2);
        }

        private void set(int i) {
            this.set(i, 1);
        }

        void set(int i, int value) {
            this.state[i] = value;
        }

        @Override
        public int compareTo(StateSet stateSet) {
            int i = 0;
            while (i < this.state.length) {
                int c = Integer.compare(this.state[i], stateSet.state[i]);
                if (c != 0) {
                    return c;
                }
                ++i;
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StateSet stateSet = (StateSet)o;
            return Arrays.equals(this.state, stateSet.state);
        }

        public int hashCode() {
            return Arrays.hashCode(this.state);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.state.length);
            int[] nArray = this.state;
            int n = this.state.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                switch (i) {
                    case 0: {
                        sb.append("0");
                        break;
                    }
                    case 1: {
                        sb.append("1");
                        break;
                    }
                    default: {
                        sb.append("-");
                    }
                }
                ++n2;
            }
            return sb.toString();
        }

        /* synthetic */ StateSet(int n, StateSet stateSet, StateSet stateSet2) {
            this(n);
        }
    }
}

