/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.cli.cli;

import de.neemann.digital.cli.cli.ArgumentBase;
import de.neemann.digital.cli.cli.CLIException;
import de.neemann.digital.lang.Lang;

public class Argument<T>
extends ArgumentBase<T> {
    private final String name;
    private final boolean optional;
    private T value;
    private boolean isSet;

    public Argument(String name, T def, boolean optional) {
        this.name = name;
        this.optional = optional;
        if (def == null) {
            throw new NullPointerException();
        }
        this.value = def;
    }

    @Override
    public T get() {
        return this.value;
    }

    @Override
    public void setString(String val) throws CLIException {
        this.value = Argument.fromString(val, this.value);
        this.isSet = true;
    }

    public static Object fromString(String val, Object defValue) throws CLIException {
        block22: {
            if (defValue instanceof String) {
                return val;
            }
            if (!(defValue instanceof Boolean)) break block22;
            switch (val.toLowerCase()) {
                case "1": 
                case "yes": 
                case "true": {
                    return true;
                }
                case "0": 
                case "no": 
                case "false": {
                    return false;
                }
            }
            throw new CLIException(Lang.get("cli_notABool_N", val), 106);
        }
        if (defValue instanceof Integer) {
            try {
                return Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                throw new CLIException(Lang.get("cli_notANumber_N", val), e);
            }
        }
        throw new CLIException(Lang.get("cli_invalidType_N", defValue.getClass().getSimpleName()), 203);
    }

    @Override
    public boolean isSet() {
        return this.isSet;
    }

    @Override
    public String getDescription(String command) {
        return Lang.get("cli_help_" + command + "_" + this.name, new Object[0]);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }
}

