/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.cli.cli;

import de.neemann.digital.cli.cli.CLICommand;
import de.neemann.digital.cli.cli.CLIException;
import de.neemann.digital.cli.cli.NamedCommand;
import de.neemann.digital.lang.Lang;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;

public class Muxer
extends NamedCommand {
    private final HashMap<String, CLICommand> commands = new HashMap();

    public Muxer(String name) {
        super(name);
    }

    public Muxer addCommand(NamedCommand command) {
        return this.addCommand(command.getName(), command);
    }

    public Muxer addCommand(String name, CLICommand command) {
        this.commands.put(name, command);
        return this;
    }

    @Override
    public void printDescription(PrintStream out, String prefix) {
        out.print(prefix);
        out.print(this.getName());
        out.println();
        for (CLICommand c : this.commands.values()) {
            c.printDescription(out, String.valueOf(prefix) + "  ");
        }
    }

    @Override
    public void printXMLDescription(Writer w) throws IOException {
        w.write("<indent>\n");
        w.write(this.getName());
        for (CLICommand c : this.commands.values()) {
            c.printXMLDescription(w);
        }
        w.write("</indent>\n");
    }

    @Override
    public void execute(String[] args) throws CLIException {
        if (args.length == 0) {
            throw new CLIException(Lang.get("cli_notEnoughArgumentsGiven", new Object[0]), 100);
        }
        CLICommand command = this.commands.get(args[0]);
        if (command == null) {
            throw new CLIException(Lang.get("cli_command_N_hasNoSubCommand_N", this.getName(), args[0]), 101);
        }
        command.execute(Arrays.copyOfRange(args, 1, args.length));
    }
}

