/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core;

import de.neemann.digital.core.ExceptionWithOriginInterface;
import de.neemann.digital.draw.elements.VisualElement;
import java.io.File;
import java.util.HashSet;
import java.util.Set;

public class ExceptionWithOrigin
extends Exception
implements ExceptionWithOriginInterface {
    private File origin;
    private VisualElement visualElement;

    public static String getOriginOf(Throwable e) {
        while (e != null) {
            Set<File> origins;
            if (e instanceof ExceptionWithOriginInterface && (origins = ((ExceptionWithOriginInterface)((Object)e)).getOrigin()) != null && origins.size() > 0) {
                StringBuilder sb = new StringBuilder();
                for (File o : origins) {
                    if (o == null) continue;
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(o.getName());
                }
                if (sb.length() > 0) {
                    return sb.toString();
                }
                return null;
            }
            e = e.getCause();
        }
        return null;
    }

    public ExceptionWithOrigin(String message) {
        super(message);
    }

    public ExceptionWithOrigin(String message, Throwable cause) {
        super(message, cause);
    }

    @Override
    public Set<File> getOrigin() {
        if (this.origin == null) {
            return null;
        }
        HashSet<File> os = new HashSet<File>();
        os.add(this.origin);
        return os;
    }

    public void setOrigin(File origin) {
        if (origin != null && this.origin == null) {
            this.origin = origin;
        }
    }

    public ExceptionWithOrigin setVisualElement(VisualElement visualElement) {
        this.visualElement = visualElement;
        return this;
    }

    public VisualElement getVisualElement() {
        return this.visualElement;
    }
}

