/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.NodeInterface;
import java.io.File;

public abstract class Node
implements NodeInterface {
    private final boolean hasState;
    private Model model;
    private int version;
    private File origin;

    public Node() {
        this(false);
    }

    public Node(boolean hasState) {
        this.hasState = hasState;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    @Override
    public final void hasChanged() {
        if (this.model == null) {
            throw new RuntimeException("noModelSet");
        }
        if (this.model.getStepCounter() != this.version) {
            this.model.addToUpdateList(this);
            this.version = this.model.getStepCounter();
        }
    }

    public abstract void readInputs() throws NodeException;

    public abstract void writeOutputs() throws NodeException;

    public void registerNodes(Model model) {
        model.add(this);
    }

    public boolean hasState() {
        return this.hasState;
    }

    public File getOrigin() {
        return this.origin;
    }

    public void setOrigin(File origin) {
        this.origin = origin;
    }

    public Model getModel() {
        return this.model;
    }
}

