/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core;

import de.neemann.digital.core.ExceptionWithOrigin;
import de.neemann.digital.core.Node;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.ImmutableList;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.lang.Lang;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class NodeException
extends ExceptionWithOrigin {
    private final ArrayList<Node> nodes;
    private final ImmutableList<ObservableValue> values;
    private final int input;

    public NodeException(String message, Exception cause) {
        this(message, null, -1, null, cause);
    }

    public NodeException(String message, ObservableValue ... values) {
        this(message, null, -1, new ObservableValues(values));
    }

    public NodeException(String message, ImmutableList<ObservableValue> values) {
        this(message, null, -1, values);
    }

    public NodeException(String message, Node node, int input, ImmutableList<ObservableValue> values) {
        this(message, node, input, values, null);
    }

    public NodeException(String message, Node node, int input, ImmutableList<ObservableValue> values, Exception cause) {
        super(message, cause);
        this.input = input;
        this.nodes = new ArrayList();
        if (node != null) {
            this.nodes.add(node);
        }
        this.values = values;
    }

    NodeException addNodes(Collection<Node> nodesToAdd) {
        this.nodes.addAll(nodesToAdd);
        return this;
    }

    public ImmutableList<ObservableValue> getValues() {
        return this.values;
    }

    @Override
    public String getMessage() {
        ItemConcatenation items = new ItemConcatenation(super.getMessage());
        if (this.values != null && this.values.size() > 0) {
            for (ObservableValue ov : this.values) {
                items.addItem(Lang.get("msg_signal_N", ov.getName()));
            }
        }
        if (this.nodes != null && this.nodes.size() > 0) {
            for (Node node : this.nodes) {
                if (node == null) continue;
                try {
                    PinDescription in;
                    Field field = node.getClass().getField("DESCRIPTION");
                    Object d = field.get(node);
                    if (!(d instanceof ElementTypeDescription)) continue;
                    ElementTypeDescription description = (ElementTypeDescription)d;
                    items.addItem(description.getTranslatedName());
                    if (this.nodes.size() != 1 || this.input < 0 || (in = description.getInput(this.input)) == null) continue;
                    items.addItem(in.getName());
                }
                catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                    // empty catch block
                }
            }
        }
        return items.toString();
    }

    public Collection<Node> getNodes() {
        return this.nodes;
    }

    @Override
    public Set<File> getOrigin() {
        Set<File> o = super.getOrigin();
        if (o != null) {
            return o;
        }
        HashSet<File> originSet = null;
        for (Node n : this.nodes) {
            if (n.getOrigin() == null) continue;
            if (originSet == null) {
                originSet = new HashSet<File>();
            }
            originSet.add(n.getOrigin());
        }
        return originSet;
    }

    private static final class Item {
        private final String item;
        private int usage;

        private Item(String item) {
            this.item = item;
        }

        private void incUsage() {
            ++this.usage;
        }

        public String toString() {
            if (this.usage == 1) {
                return this.item;
            }
            return String.valueOf(this.usage) + "*" + this.item;
        }
    }

    private static final class ItemConcatenation {
        private final String message;
        private final HashMap<String, Item> items;

        private ItemConcatenation(String message) {
            this.message = message;
            this.items = new HashMap();
        }

        private void addItem(String item) {
            Item it = this.items.computeIfAbsent(item, string -> new Item((String)string));
            it.incUsage();
        }

        public String toString() {
            if (this.items.isEmpty()) {
                return this.message;
            }
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Item e : this.items.values()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(e);
            }
            return String.valueOf(this.message) + "\n" + Lang.get("msg_affectedComponentsAre_N", sb.toString());
        }
    }
}

