/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.wiring.Clock;
import de.neemann.digital.lang.Lang;
import java.util.ArrayList;

public class SpeedTest {
    private static final int LOOPCOUNTER = 10000;
    private final Model model;

    public SpeedTest(Model model) {
        this.model = model;
    }

    public double calculate() throws NodeException {
        long aktTime;
        ArrayList<Clock> clocks = this.model.getClocks();
        if (clocks.isEmpty()) {
            throw new NodeException(Lang.get("err_noClockFound", new Object[0]), new ObservableValue[0]);
        }
        if (clocks.size() > 1) {
            throw new NodeException(Lang.get("err_moreThanOneClockFound", new Object[0]), new ObservableValue[0]);
        }
        Clock clock = clocks.get(0);
        this.model.init();
        ObservableValue clockValue = (ObservableValue)clock.getOutputs().get(0);
        int state = (int)clockValue.getValue();
        long starTime = System.currentTimeMillis();
        int loops = 0;
        do {
            int i = 0;
            while (i < 10000) {
                state = 1 - state;
                clockValue.setValue(state);
                this.model.doStep();
                ++i;
            }
            ++loops;
        } while ((aktTime = System.currentTimeMillis()) - starTime < 1000L);
        long cycles = (long)loops * 10000L / 2L;
        double time = (double)(aktTime - starTime) / 1000.0;
        double frequency = (double)cycles / time;
        System.out.println("cycles: " + cycles);
        System.out.println("time  : " + time + "s");
        System.out.println("freq  :" + frequency);
        return frequency;
    }
}

