/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.element;

import de.neemann.digital.lang.Lang;
import java.io.File;

public class Key<VALUE> {
    private final String key;
    private final DefaultFactory<VALUE> defFactory;
    private String langKey;
    private boolean groupEditAllowed = false;
    private Key dependsOn;
    private CheckEnabled checkEnabled;
    private boolean isSecondary;
    private boolean requiresRestart = false;
    private boolean requiresRepaint = false;
    private String panelId;
    private String name;
    private String description;
    private boolean adaptiveIntFormat;

    public Key(String key, VALUE def) {
        this(key, () -> def);
        if (def == null) {
            throw new NullPointerException();
        }
    }

    public Key(String key, DefaultFactory<VALUE> defFactory) {
        this.key = key;
        this.langKey = "key_" + key.replace(" ", "");
        if (defFactory == null) {
            throw new NullPointerException();
        }
        this.defFactory = defFactory;
    }

    Key<VALUE> useTranslationOf(Key key) {
        this.langKey = key.langKey;
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return Lang.get(this.langKey, new Object[0]);
    }

    public VALUE getDefault() {
        return this.defFactory.createDefault();
    }

    public Class getValueClass() {
        return this.getDefault().getClass();
    }

    public String toString() {
        return this.getName();
    }

    public String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        String d = Lang.getNull(String.valueOf(this.langKey) + "_tt", new Object[0]);
        if (d != null) {
            return d;
        }
        return this.getName();
    }

    public String getLangKey() {
        return this.langKey;
    }

    public boolean isGroupEditAllowed() {
        return this.groupEditAllowed;
    }

    public Key<VALUE> allowGroupEdit() {
        this.groupEditAllowed = true;
        return this;
    }

    public Key<VALUE> setName(String name) {
        this.name = name;
        return this;
    }

    public Key<VALUE> setDescription(String description) {
        this.description = description;
        return this;
    }

    public Key getDependsOn() {
        return this.dependsOn;
    }

    public CheckEnabled getCheckEnabled() {
        return this.checkEnabled;
    }

    public Key<VALUE> setDependsOn(Key<Boolean> key) {
        return this.setDependsOn(key, o -> o);
    }

    public <KV> Key<VALUE> setDependsOn(Key<KV> key, CheckEnabled<KV> checkEnabled) {
        this.dependsOn = key;
        this.checkEnabled = checkEnabled;
        return this;
    }

    public boolean isSecondary() {
        return this.isSecondary;
    }

    public Key<VALUE> setSecondary() {
        this.isSecondary = true;
        return this;
    }

    public Key<VALUE> setRequiresRestart() {
        this.requiresRestart = true;
        return this;
    }

    public boolean getRequiresRestart() {
        return this.requiresRestart;
    }

    public Key<VALUE> setRequiresRepaint() {
        this.requiresRepaint = true;
        return this;
    }

    public boolean getRequiresRepaint() {
        return this.requiresRepaint;
    }

    public Key<VALUE> setAdaptiveIntFormat() {
        this.adaptiveIntFormat = true;
        return this;
    }

    public boolean isAdaptiveIntFormat() {
        return this.adaptiveIntFormat;
    }

    public Key<VALUE> setPanelId(String panelId) {
        this.panelId = panelId;
        return this;
    }

    public String getPanelId() {
        return this.panelId;
    }

    public static interface CheckEnabled<T> {
        public boolean isEnabled(T var1);
    }

    public static interface DefaultFactory<VALUE> {
        public VALUE createDefault();
    }

    public static final class KeyBits
    extends KeyInteger {
        public KeyBits(String key, Integer def) {
            super(key, def);
            this.setMin(1);
            this.setMax(64);
            this.setComboBoxValues(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 32);
            this.allowGroupEdit();
        }
    }

    public static final class KeyEnum<E extends Enum>
    extends Key<E> {
        private final E[] values;
        private final String[] names;
        private final boolean toString;

        public KeyEnum(String key, E def, E[] values) {
            this(key, (Enum)def, (Enum[])values, false);
        }

        public KeyEnum(String key, E def, E[] values, boolean toString) {
            super(key, def);
            this.values = values;
            this.toString = toString;
            this.names = new String[values.length];
            if (toString) {
                int i = 0;
                while (i < values.length) {
                    this.names[i] = ((Enum)values[i]).toString();
                    ++i;
                }
            } else {
                int i = 0;
                while (i < values.length) {
                    this.names[i] = Lang.get(this.getLangKey(values[i]), new Object[0]);
                    ++i;
                }
            }
            this.allowGroupEdit();
        }

        public String getLangKey(E value) {
            return String.valueOf(this.getLangKey()) + "_" + ((Enum)value).name();
        }

        public E[] getValues() {
            return this.values;
        }

        public String[] getNames() {
            return this.names;
        }

        public boolean usesToString() {
            return this.toString;
        }
    }

    public static final class KeyFile
    extends Key<File> {
        private boolean directoryOnly;

        public KeyFile(String key, File def) {
            super(key, def);
            this.setDirectoryOnly(false);
        }

        public KeyFile setDirectoryOnly(boolean directoryOnly) {
            this.directoryOnly = directoryOnly;
            return this;
        }

        public boolean isDirectoryOnly() {
            return this.directoryOnly;
        }
    }

    public static class KeyInteger
    extends Key<Integer> {
        private int[] values;
        private int min = Integer.MIN_VALUE;
        private int max = Integer.MAX_VALUE;

        public KeyInteger(String key, Integer def) {
            super(key, def);
        }

        public KeyInteger setComboBoxValues(int ... values) {
            this.values = values;
            return this;
        }

        public KeyInteger setMin(int min) {
            this.min = min;
            return this;
        }

        public KeyInteger setMax(int max) {
            this.max = max;
            return this;
        }

        public int[] getComboBoxValues() {
            return this.values;
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        public boolean isMinOrMaxSet() {
            return this.max != Integer.MAX_VALUE || this.min != Integer.MIN_VALUE;
        }
    }

    public static final class LongString
    extends Key<String> {
        private int rows = 6;
        private int columns = 0;
        private boolean lineNumbers = false;

        public LongString(String key) {
            super(key, "");
        }

        public LongString(String key, String def) {
            super(key, def);
        }

        public int getRows() {
            return this.rows;
        }

        public LongString setRows(int rows) {
            this.rows = rows;
            return this;
        }

        public int getColumns() {
            return this.columns;
        }

        public LongString setColumns(int columns) {
            this.columns = columns;
            return this;
        }

        public LongString setLineNumbers(boolean lineNumbers) {
            this.lineNumbers = lineNumbers;
            return this;
        }

        public boolean getLineNumbers() {
            return this.lineNumbers;
        }
    }
}

