/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.extern;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.core.extern.Application;
import de.neemann.digital.core.extern.External;
import de.neemann.digital.core.extern.PortDefinition;
import de.neemann.digital.lang.Lang;
import java.io.File;
import java.io.IOException;

public class ExternalFile
extends External {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(ExternalFile.class, new PinDescription[0]){

        @Override
        public PinDescriptions getInputDescription(ElementAttributes elementAttributes) {
            return new PortDefinition(elementAttributes.get(Keys.EXTERNAL_INPUTS)).getPinDescriptions(PinDescription.Direction.input);
        }

        @Override
        public PinDescriptions getOutputDescriptions(ElementAttributes elementAttributes) {
            return new PortDefinition(elementAttributes.get(Keys.EXTERNAL_OUTPUTS)).getPinDescriptions(PinDescription.Direction.output);
        }
    }.addAttribute(Keys.LABEL).addAttribute(Keys.WIDTH).addAttribute(Keys.EXTERNAL_INPUTS).addAttribute(Keys.EXTERNAL_OUTPUTS).addAttribute(Keys.EXTERNAL_CODE_FILE).addAttribute(Keys.APPLICATION_TYPE).addAttribute(Keys.GHDL_OPTIONS).addAttribute(Keys.IVERILOG_OPTIONS).supportsHDL();
    private final ElementAttributes attr;

    public ExternalFile(ElementAttributes attr) {
        super(attr);
        this.attr = attr;
    }

    @Override
    public void init(Model model) throws NodeException {
        File file = this.attr.getFile(Keys.EXTERNAL_CODE_FILE, model.getRootPath());
        try {
            this.setCode(Application.readCode(file));
        }
        catch (IOException e) {
            throw new NodeException(Lang.get("err_errorLoadingHDLFile_N", file), new ObservableValue[0]);
        }
        super.init(model);
    }
}

