/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.extern;

import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Key;
import de.neemann.digital.gui.Settings;
import java.util.ArrayList;

public class Options {
    private final ArrayList<String> list = new ArrayList();

    public Options addFromSettings(Key<String> key) {
        return this.addString(Settings.getInstance().get(key));
    }

    public Options addString(String options) {
        StringBuilder opt = new StringBuilder();
        boolean inQuote = false;
        int quoteCount = 0;
        int i = 0;
        while (i < options.length()) {
            char c = options.charAt(i);
            if (c == '\"') {
                inQuote = !inQuote;
                ++quoteCount;
            }
            if (c == '\\' && i < options.length() - 1 && !inQuote) {
                opt.append(this.escapeChar(options.charAt(++i)));
            } else if (Character.isWhitespace(c) && !inQuote) {
                if (opt.length() > 0) {
                    this.addQuote(opt.toString(), quoteCount);
                    quoteCount = 0;
                }
                opt.setLength(0);
            } else {
                opt.append(c);
            }
            ++i;
        }
        if (opt.length() > 0) {
            this.addQuote(opt.toString(), quoteCount);
        }
        return this;
    }

    private void addQuote(String opt, int quoteCount) {
        if (quoteCount == 2 && opt.charAt(0) == '\"' && opt.charAt(opt.length() - 1) == '\"') {
            this.list.add(opt.substring(1, opt.length() - 1));
        } else {
            this.list.add(opt);
        }
    }

    private char escapeChar(char c) {
        switch (c) {
            case 't': {
                return '\t';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
        }
        return c;
    }

    public Options add(String option) {
        this.list.add(option);
        return this;
    }

    public Options add(ElementAttributes attr, Key<String> key) {
        return this.addString(attr.get(key));
    }

    public ArrayList<String> getList() {
        return this.list;
    }

    public String[] getArray() {
        return this.list.toArray(new String[0]);
    }
}

