/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.extern;

import de.neemann.digital.core.Bits;
import de.neemann.digital.hdl.hgs.HGSMap;

public class Param
implements HGSMap {
    private final int bits;
    private final int val;
    private final String name;

    public Param(String name, int bits, int val) {
        this.name = name;
        this.bits = bits;
        this.val = val;
    }

    public Param(String param) {
        this.val = 0;
        int p = param.indexOf(58);
        if (p < 0) {
            this.name = param;
            this.bits = 32;
        } else {
            this.name = param.substring(0, p);
            int b = 1;
            try {
                b = (int)Bits.decode(param.substring(p + 1));
            }
            catch (Bits.NumberFormatException e) {
                b = 32;
            }
            this.bits = b;
        }
    }

    public int getBits() {
        return this.bits;
    }

    public int getVal() {
        return this.val;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        if (this.bits == 1) {
            return this.name;
        }
        return String.valueOf(this.name) + ":" + this.bits;
    }

    @Override
    public Object hgsMapGet(String key) {
        switch (key) {
            case "name": {
                return this.name;
            }
            case "bits": {
                return this.bits;
            }
        }
        return null;
    }
}

