/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.extern;

import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.core.extern.Param;
import de.neemann.digital.hdl.hgs.HGSArray;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;

public class ParamDefinition
implements Iterable<Param>,
HGSArray {
    private final ArrayList<Param> params = new ArrayList();

    public ParamDefinition(String paramDescription) {
        StringTokenizer st = new StringTokenizer(paramDescription, ",");
        while (st.hasMoreTokens()) {
            this.params.add(new Param(st.nextToken().trim()));
        }
    }

    public ObservableValues createOutputs() {
        ObservableValues.Builder builder = new ObservableValues.Builder();
        for (Param p : this.params) {
            builder.add(new ObservableValue(p.getName(), p.getBits()));
        }
        return builder.build();
    }

    public PinDescriptions getPinDescriptions(PinDescription.Direction direction) {
        PinDescription[] infos = new PinInfo[this.params.size()];
        int i = 0;
        while (i < infos.length) {
            infos[i] = new PinInfo(this.params.get(i).getName(), "", direction);
            ++i;
        }
        return new PinDescriptions(infos);
    }

    public Param getParam(int i) {
        return this.params.get(i);
    }

    public int getParamVal(String name) {
        int val = 0;
        for (Param p : this.params) {
            if (!p.getName().equals(name)) continue;
            val = p.getVal();
            break;
        }
        return val;
    }

    public int getBits() {
        int bits = 0;
        for (Param p : this.params) {
            bits += p.getBits();
        }
        return bits;
    }

    @Override
    public Iterator<Param> iterator() {
        return this.params.iterator();
    }

    public void addParam(String name, int bits, int val) {
        this.params.add(new Param(name, bits, val));
    }

    public int size() {
        return this.params.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Param p : this.params) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(p.toString());
        }
        return sb.toString();
    }

    @Override
    public int hgsArraySize() {
        return this.params.size();
    }

    @Override
    public Object hgsArrayGet(int i) {
        return this.params.get(i);
    }
}

