/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.flipflops;

import de.neemann.digital.core.BitsException;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.core.flipflops.FlipflopBit;

public class FlipflopT
extends FlipflopBit {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription("T_FF", FlipflopT.class, new PinDescription[0]){

        @Override
        public PinDescriptions getInputDescription(ElementAttributes elementAttributes) throws NodeException {
            if (elementAttributes.get(Keys.WITH_ENABLE).booleanValue()) {
                return new PinDescriptions(new PinDescription[]{PinInfo.input("T"), PinInfo.input("C").setClock()}).setLangKey(this.getPinLangKey());
            }
            return new PinDescriptions(new PinDescription[]{PinInfo.input("C").setClock()}).setLangKey(this.getPinLangKey());
        }
    }.addAttribute(Keys.ROTATE).addAttribute(Keys.MIRROR).addAttribute(Keys.LABEL).addAttribute(Keys.WITH_ENABLE).addAttribute(Keys.DEFAULT).addAttribute(Keys.INVERTER_CONFIG).addAttribute(Keys.VALUE_IS_PROBE);
    private final boolean isEnable;
    private ObservableValue clockVal;
    private ObservableValue enable;
    private boolean lastClock;

    public FlipflopT(ElementAttributes attributes) {
        super(attributes, DESCRIPTION);
        this.isEnable = attributes.get(Keys.WITH_ENABLE);
    }

    @Override
    public void readInputs() throws NodeException {
        boolean clock = this.clockVal.getBool();
        if (clock && !this.lastClock) {
            if (this.enable == null) {
                this.setOut(!this.isOut());
            } else if (this.enable.getBool()) {
                this.setOut(!this.isOut());
            }
        }
        this.lastClock = clock;
    }

    @Override
    public void setInputs(ObservableValues inputs) throws BitsException {
        if (this.isEnable) {
            this.enable = ((ObservableValue)inputs.get(0)).checkBits(1, this, 0);
            this.clockVal = ((ObservableValue)inputs.get(1)).addObserverToValue(this).checkBits(1, this, 1);
        } else {
            this.clockVal = ((ObservableValue)inputs.get(0)).addObserverToValue(this).checkBits(1, this, 0);
        }
    }

    public ObservableValue getClockVal() {
        return this.clockVal;
    }

    public ObservableValue getEnableVal() {
        return this.enable;
    }
}

