/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.flipflops;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.core.flipflops.FlipflopBit;
import de.neemann.digital.core.wiring.Clock;
import de.neemann.digital.lang.Lang;
import java.util.ArrayList;

public class Monoflop
extends FlipflopBit {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(Monoflop.class, PinInfo.input("C").setClock(), PinInfo.input("R")).addAttribute(Keys.ROTATE).addAttribute(Keys.MIRROR).addAttribute(Keys.LABEL).addAttribute(Keys.DEFAULT).addAttribute(Keys.MONOFLOP_DELAY).addAttribute(Keys.INVERTER_CONFIG).addAttribute(Keys.VALUE_IS_PROBE);
    private final int delayTime;
    private ObservableValue clock;
    private ObservableValue rst;
    private boolean lastClock;
    private int counter;

    public Monoflop(ElementAttributes attr) {
        super(attr, DESCRIPTION);
        this.delayTime = attr.get(Keys.MONOFLOP_DELAY);
        this.counter = this.isOut() ? this.delayTime : 0;
    }

    @Override
    public void readInputs() throws NodeException {
        boolean clockVal = this.clock.getBool();
        if (this.rst.getBool()) {
            this.setOut(false);
        } else if (clockVal && !this.lastClock) {
            this.counter = this.delayTime;
            this.setOut(true);
        }
        this.lastClock = clockVal;
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        this.clock = ((ObservableValue)inputs.get(0)).checkBits(1, this).addObserverToValue(this);
        this.rst = ((ObservableValue)inputs.get(1)).checkBits(1, this).addObserverToValue(this);
    }

    @Override
    public void init(Model model) throws NodeException {
        ArrayList<Clock> clockList = model.getClocks();
        if (clockList.size() != 1) {
            throw new NodeException(Lang.get("err_monoflopRequiresOneClock", new Object[0]), new ObservableValue[0]);
        }
        ObservableValue clock = clockList.get(0).getClockOutput();
        clock.addObserver(() -> {
            if (clock.getBool() && this.counter > 0) {
                --this.counter;
                if (this.counter == 0) {
                    this.setOut(false);
                    this.hasChanged();
                }
            }
        });
    }
}

