/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.io;

import de.neemann.digital.core.Bits;
import de.neemann.digital.core.ObservableValue;

public class InValue {
    private final long value;
    private final boolean highZ;

    public InValue(long value) {
        this.value = value;
        this.highZ = false;
    }

    public InValue(ObservableValue value) {
        if (value.isHighZ()) {
            this.highZ = true;
            this.value = 0L;
        } else {
            this.highZ = false;
            this.value = value.getValue();
        }
    }

    public InValue(String value) throws Bits.NumberFormatException {
        if (value.trim().equalsIgnoreCase("z")) {
            this.highZ = true;
            this.value = 0L;
        } else {
            this.highZ = false;
            this.value = Bits.decode(value.trim(), true);
        }
    }

    public long getValue() {
        return this.value;
    }

    public boolean isHighZ() {
        return this.highZ;
    }

    public String toString() {
        if (this.highZ) {
            return "Z";
        }
        return Long.toString(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InValue inValue = (InValue)o;
        if (this.value != inValue.value) {
            return false;
        }
        return this.highZ == inValue.highZ;
    }

    public int hashCode() {
        int result = (int)(this.value ^ this.value >>> 32);
        result = 31 * result + (this.highZ ? 1 : 0);
        return result;
    }
}

