/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.io;

import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.core.io.StepperMotorUnipolar;

public class StepperMotorBipolar
extends StepperMotorUnipolar {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(StepperMotorBipolar.class, PinInfo.input("A+"), PinInfo.input("A-"), PinInfo.input("B+"), PinInfo.input("B-")).addAttribute(Keys.ROTATE).addAttribute(Keys.LABEL).addAttribute(Keys.INVERT_OUTPUT);
    private ObservableValue aPlus;
    private ObservableValue aMinus;
    private ObservableValue bPlus;
    private ObservableValue bMinus;

    public StepperMotorBipolar(ElementAttributes attr) {
        super(attr);
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        this.aPlus = ((ObservableValue)inputs.get(0)).checkBits(1, this).addObserverToValue(this);
        this.aMinus = ((ObservableValue)inputs.get(1)).checkBits(1, this).addObserverToValue(this);
        this.bPlus = ((ObservableValue)inputs.get(2)).checkBits(1, this).addObserverToValue(this);
        this.bMinus = ((ObservableValue)inputs.get(3)).checkBits(1, this).addObserverToValue(this);
    }

    @Override
    protected boolean reverse() {
        return false;
    }

    @Override
    protected int getState() {
        int a = this.getCoilState(this.aPlus, this.aMinus);
        int b = this.getCoilState(this.bPlus, this.bMinus);
        int state = 0;
        if (a < 0) {
            state |= 1;
        }
        if (a > 0) {
            state |= 4;
        }
        if (b < 0) {
            state |= 2;
        }
        if (b > 0) {
            state |= 8;
        }
        return state;
    }

    private int getCoilState(ObservableValue aPlus, ObservableValue aMinus) {
        if (!aPlus.isHighZ() && !aMinus.isHighZ()) {
            if (aPlus.getBool() && !aMinus.getBool()) {
                return 1;
            }
            if (!aPlus.getBool() && aMinus.getBool()) {
                return -1;
            }
        }
        return 0;
    }
}

