/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.io.telnet;

public class ByteBuffer {
    private final byte[] data;
    private final int size;
    private int inBuffer;
    private int newest;
    private int oldest;

    public ByteBuffer(int size) {
        this.data = new byte[size];
        this.size = size;
    }

    public synchronized void put(byte value) {
        if (this.inBuffer < this.size) {
            this.data[this.newest] = value;
            this.newest = this.inc(this.newest);
            ++this.inBuffer;
        }
    }

    public synchronized byte peek() {
        if (this.inBuffer > 0) {
            return this.data[this.oldest];
        }
        return -1;
    }

    public synchronized void delete() {
        if (this.inBuffer > 0) {
            this.oldest = this.inc(this.oldest);
            --this.inBuffer;
        }
    }

    public synchronized void deleteAll() {
        this.oldest = 0;
        this.newest = 0;
        this.inBuffer = 0;
    }

    public synchronized boolean hasData() {
        return this.inBuffer > 0;
    }

    private int inc(int n) {
        if (++n >= this.size) {
            n = 0;
        }
        return n;
    }
}

