/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.memory;

import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.core.memory.ROM;

public class ROMDualPort
extends ROM {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(ROMDualPort.class, PinInfo.input("A1"), PinInfo.input("s1"), PinInfo.input("A2"), PinInfo.input("s2")).addAttribute(Keys.ROTATE).addAttribute(Keys.BITS).addAttribute(Keys.ADDR_BITS).addAttribute(Keys.LABEL).addAttribute(Keys.DATA).addAttribute(Keys.INT_FORMAT).addAttribute(Keys.IS_PROGRAM_MEMORY).addAttribute(Keys.AUTO_RELOAD_ROM).addAttribute(Keys.LAST_DATA_FILE).addAttribute(Keys.BIG_ENDIAN);
    private final ObservableValue output2 = new ObservableValue("D2", this.getDataBits()).setToHighZ().setPinDescription(DESCRIPTION);
    private ObservableValue addrIn2;
    private ObservableValue selIn2;
    private int addr2;
    private boolean sel2;

    public ROMDualPort(ElementAttributes attr) {
        super(attr);
    }

    @Override
    ObservableValue createOutput1() {
        return new ObservableValue("D1", this.getDataBits()).setToHighZ().setPinDescription(DESCRIPTION);
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        super.setInputs(inputs);
        this.addrIn2 = ((ObservableValue)inputs.get(2)).checkBits(this.getAddrBits(), this, 2).addObserverToValue(this);
        this.selIn2 = ((ObservableValue)inputs.get(3)).checkBits(1, this, 3).addObserverToValue(this);
    }

    @Override
    public void readInputs() throws NodeException {
        super.readInputs();
        this.addr2 = (int)this.addrIn2.getValue();
        this.sel2 = this.selIn2.getBool();
    }

    @Override
    public void writeOutputs() throws NodeException {
        super.writeOutputs();
        if (this.sel2) {
            this.output2.setValue(this.getDataWord(this.addr2));
        } else {
            this.output2.setToHighZ();
        }
    }

    @Override
    public ObservableValues getOutputs() {
        ObservableValue output1 = (ObservableValue)super.getOutputs().get(0);
        return new ObservableValues(output1, this.output2);
    }
}

