/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.memory.importer;

import de.neemann.digital.core.Bits;
import de.neemann.digital.core.memory.importer.ValueArray;
import de.neemann.digital.core.memory.importer.ValueArrayReader;
import de.neemann.digital.lang.Lang;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;

public class LogisimReader
implements ValueArrayReader {
    private final Reader reader;

    public LogisimReader(File file) throws FileNotFoundException {
        this(new FileReader(file));
    }

    public LogisimReader(Reader reader) {
        this.reader = reader;
    }

    @Override
    public void read(ValueArray valueArray) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader bufferedReader = new BufferedReader(this.reader);){
            String header = bufferedReader.readLine();
            if (header == null || !header.equals("v2.0 raw")) {
                throw new IOException(Lang.get("err_invalidFileFormat", new Object[0]));
            }
            StreamTokenizer t = new StreamTokenizer(bufferedReader);
            t.resetSyntax();
            t.commentChar(35);
            t.wordChars(97, 102);
            t.wordChars(65, 70);
            t.wordChars(120, 120);
            t.wordChars(88, 88);
            t.wordChars(48, 57);
            t.whitespaceChars(0, 32);
            int pos = 0;
            while (t.nextToken() != -1) {
                try {
                    String vStr = t.sval;
                    if (vStr == null) {
                        throw new IOException("invalid token in line " + t.lineno());
                    }
                    if (t.nextToken() == 42) {
                        t.nextToken();
                        if (t.sval == null) {
                            throw new IOException("invalid token in line " + t.lineno());
                        }
                        long v = this.getHexLong(t.sval);
                        int reps = (int)Bits.decode(vStr, 0, 10);
                        int i = 0;
                        while (i < reps) {
                            valueArray.set(pos, v);
                            ++pos;
                            ++i;
                        }
                        continue;
                    }
                    t.pushBack();
                    valueArray.set(pos, this.getHexLong(vStr));
                    ++pos;
                }
                catch (Bits.NumberFormatException e) {
                    throw new IOException(e);
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private long getHexLong(String vStr) throws Bits.NumberFormatException {
        int p = 0;
        if (vStr.length() > 2 && vStr.charAt(0) == '0' && (vStr.charAt(1) == 'x' || vStr.charAt(1) == 'X')) {
            p = 2;
        }
        return Bits.decode(vStr, p, 16);
    }
}

