/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.memory.importer;

import de.neemann.digital.core.memory.DataField;
import de.neemann.digital.core.memory.importer.DataFieldValueArray;
import de.neemann.digital.core.memory.importer.ValueArray;
import de.neemann.digital.lang.Lang;
import java.util.ArrayList;

public final class MultiValueArray
implements ValueArray {
    private final ValueArray[] valueArrays;
    private final int bytes;
    private final int memCount;

    private MultiValueArray(ValueArray ... valueArrays) {
        this.valueArrays = valueArrays;
        this.memCount = valueArrays.length;
        this.bytes = valueArrays[0].getBytesPerValue();
    }

    @Override
    public void set(int index, long value) {
        int a = index / this.memCount;
        int b = index % this.memCount;
        this.valueArrays[b].set(a, value);
    }

    @Override
    public long get(int index) {
        int a = index / this.memCount;
        int b = index % this.memCount;
        return this.valueArrays[b].get(a);
    }

    @Override
    public int getBytesPerValue() {
        return this.bytes;
    }

    /* synthetic */ MultiValueArray(ValueArray[] valueArrayArray, MultiValueArray multiValueArray) {
        this(valueArrayArray);
    }

    public static class Builder {
        private ArrayList<ValueArray> valueArrays = new ArrayList();
        private int bytes;

        public Builder add(DataField dataField, int bits) throws ValueArrayException {
            return this.add(new DataFieldValueArray(dataField, bits));
        }

        public Builder add(ValueArray valueArray) throws ValueArrayException {
            if (this.valueArrays.isEmpty()) {
                this.bytes = valueArray.getBytesPerValue();
            }
            if (valueArray.getBytesPerValue() != this.bytes) {
                throw new ValueArrayException(Lang.get("err_allMemoriesNeedToHaveTheSameByteWidth", new Object[0]));
            }
            this.valueArrays.add(valueArray);
            return this;
        }

        public ValueArray build() throws ValueArrayException {
            switch (this.valueArrays.size()) {
                case 0: {
                    throw new ValueArrayException(Lang.get("err_noRomFound", new Object[0]));
                }
                case 1: {
                    return this.valueArrays.get(0);
                }
            }
            return new MultiValueArray(this.valueArrays.toArray(new ValueArray[0]), null);
        }
    }

    public static class ValueArrayException
    extends Exception {
        public ValueArrayException(String message) {
            super(message);
        }
    }
}

