/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.switching;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.core.stats.Countable;
import de.neemann.digital.core.switching.Switch;

public class Relay
extends Node
implements Element,
Countable {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(Relay.class, PinInfo.input("in1"), PinInfo.input("in2")).addAttribute(Keys.ROTATE).addAttribute(Keys.MIRROR).addAttribute(Keys.BITS).addAttribute(Keys.LABEL).addAttribute(Keys.POLES).addAttribute(Keys.RELAY_NORMALLY_CLOSED);
    private final boolean invers;
    private ObservableValue input1;
    private ObservableValue input2;
    private final Switch s;

    public Relay(ElementAttributes attr) {
        super(false);
        this.invers = attr.get(Keys.RELAY_NORMALLY_CLOSED);
        this.s = new Switch(attr, this.invers);
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        this.input1 = ((ObservableValue)inputs.get(0)).checkBits(1, this).addObserverToValue(this);
        this.input2 = ((ObservableValue)inputs.get(1)).checkBits(1, this).addObserverToValue(this);
        this.s.setInputs(new ObservableValues(inputs, 2, inputs.size()));
    }

    @Override
    public void readInputs() {
        if (this.input1.isHighZ() || this.input2.isHighZ()) {
            this.s.setClosed(this.invers);
        } else {
            this.s.setClosed(this.input1.getBool() ^ this.input2.getBool() ^ this.invers);
        }
    }

    @Override
    public void writeOutputs() throws NodeException {
    }

    @Override
    public ObservableValues getOutputs() {
        return this.s.getOutputs();
    }

    @Override
    public void init(Model model) {
        this.s.init(model);
    }

    public boolean isClosed() {
        return this.s.isClosed();
    }

    @Override
    public int getDataBits() {
        return this.s.getDataBits();
    }

    @Override
    public int getInputsCount() {
        return this.s.getInputsCount();
    }
}

