/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.switching;

import de.neemann.digital.core.BurnException;
import de.neemann.digital.core.Model;
import de.neemann.digital.core.ModelEventType;
import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.core.switching.PlainSwitch;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.lang.Lang;

public class TransGate
extends Node
implements Element {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(TransGate.class, PinInfo.input("S"), PinInfo.input("~S")).addAttribute(Keys.ROTATE).addAttribute(Keys.BITS);
    private final PlainSwitch aSwitch;
    private ObservableValue s;
    private ObservableValue ns;
    private boolean closed;

    public TransGate(ElementAttributes attr) {
        this.aSwitch = new PlainSwitch(attr.getBits(), false, "A", "B");
        this.aSwitch.getOutput1().setPinDescription(DESCRIPTION);
        this.aSwitch.getOutput2().setPinDescription(DESCRIPTION);
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        this.s = ((ObservableValue)inputs.get(0)).checkBits(1, this, 0).addObserverToValue(this);
        this.ns = ((ObservableValue)inputs.get(1)).checkBits(1, this, 1).addObserverToValue(this);
        this.aSwitch.setInputs((ObservableValue)inputs.get(2), (ObservableValue)inputs.get(3));
    }

    @Override
    public ObservableValues getOutputs() throws PinException {
        return this.aSwitch.getOutputs();
    }

    @Override
    public void readInputs() throws NodeException {
        if (this.s.isHighZ() || this.ns.isHighZ()) {
            this.closed = false;
        } else if (this.s.getBool() != this.ns.getBool()) {
            this.closed = this.s.getBool();
        }
    }

    @Override
    public void writeOutputs() throws NodeException {
        this.aSwitch.setClosed(this.closed);
    }

    @Override
    public void init(Model model) throws NodeException {
        this.aSwitch.init(model);
        model.addObserver(event -> {
            if (event.getType().equals((Object)ModelEventType.STEP) && !this.s.isHighZ() && !this.ns.isHighZ() && this.s.getBool() == this.ns.getBool()) {
                throw new BurnException(Lang.get("err_invalidTransmissionGateState", new Object[0]), new ObservableValues(this.s, this.ns));
            }
        }, ModelEventType.STEP, new ModelEventType[0]);
    }

    public boolean isClosed() {
        return this.closed;
    }
}

