/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.data;

import de.neemann.digital.core.Bits;
import de.neemann.digital.core.IntFormat;
import de.neemann.digital.core.ObservableValue;

public class Value {
    private final long value;
    private final Type type;

    public static Value getHighZ() {
        return new Value(0L, Type.HIGHZ);
    }

    public Value(Value value) {
        this.value = value.value;
        this.type = value.type;
    }

    public Value(long val) {
        this.value = val;
        this.type = Type.NORMAL;
    }

    private Value(long val, Type type) {
        this.value = val;
        this.type = type;
    }

    public Value(ObservableValue ov) {
        this.value = ov.getValue();
        this.type = ov.isHighZ() ? Type.HIGHZ : Type.NORMAL;
    }

    public Value(String val) throws Bits.NumberFormatException {
        switch (val = val.trim().toUpperCase()) {
            case "X": {
                this.value = 0L;
                this.type = Type.DONTCARE;
                break;
            }
            case "Z": {
                this.value = 0L;
                this.type = Type.HIGHZ;
                break;
            }
            case "C": {
                this.value = 1L;
                this.type = Type.CLOCK;
                break;
            }
            default: {
                this.value = Bits.decode(val);
                this.type = Type.NORMAL;
            }
        }
    }

    public boolean isEqualTo(Value v) {
        return this.isEqualTo(v, 0L);
    }

    protected boolean isEqualTo(Value v, long mask) {
        if (this == v) {
            return true;
        }
        if (v == null) {
            return false;
        }
        if (v.type == Type.DONTCARE || this.type == Type.DONTCARE) {
            return true;
        }
        if (v.type != this.type) {
            return false;
        }
        if (this.type == Type.HIGHZ) {
            return true;
        }
        if (mask == 0L) {
            return this.value == v.value;
        }
        return (this.value & mask) == (v.value & mask);
    }

    public String toString() {
        switch (this.type) {
            case HIGHZ: {
                return "Z";
            }
            case DONTCARE: {
                return "X";
            }
            case CLOCK: {
                return "C";
            }
        }
        return IntFormat.toShortHex(this.value);
    }

    public Type getType() {
        return this.type;
    }

    public State getState() {
        return State.NORMAL;
    }

    public boolean isHighZ() {
        return this.type == Type.HIGHZ;
    }

    public long getValue() {
        return this.value;
    }

    public void copyTo(ObservableValue ov) {
        if (this.isHighZ()) {
            ov.setToHighZ();
        } else {
            ov.setValue(this.value);
        }
    }

    public static enum State {
        NORMAL,
        PASS,
        FAIL;

    }

    public static enum Type {
        NORMAL,
        DONTCARE,
        HIGHZ,
        CLOCK;

    }
}

