/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.data;

import de.neemann.digital.core.Observer;
import de.neemann.digital.data.Value;
import de.neemann.digital.data.ValueTable;
import de.neemann.digital.testing.parser.TestRow;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class ValueTableModel
implements TableModel,
Observer {
    private final ValueTable values;
    private final ArrayList<TableModelListener> listeners;

    public ValueTableModel(ValueTable values) {
        this.values = values;
        this.listeners = new ArrayList();
        values.addObserver(this);
    }

    @Override
    public int getRowCount() {
        return this.values.getTableRows();
    }

    @Override
    public int getColumnCount() {
        return this.values.getColumns() + 1;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "";
        }
        return this.values.getColumnName(columnIndex - 1);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return String.class;
        }
        return Value.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            String description = this.values.getDescription(rowIndex);
            if (description == null) {
                return "";
            }
            return description;
        }
        return this.values.getTableValue(rowIndex, columnIndex - 1);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void hasChanged() {
        SwingUtilities.invokeLater(() -> {
            TableModelEvent tme = new TableModelEvent(this);
            for (TableModelListener l : this.listeners) {
                l.tableChanged(tme);
            }
        });
    }

    public TestRow getRow(int row) {
        return this.values.getTableRow(row);
    }
}

