/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.elements;

import de.neemann.digital.core.SyncAccess;
import de.neemann.digital.core.Value;
import de.neemann.digital.core.element.AttributeListener;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Key;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.Rotation;
import de.neemann.digital.core.io.Const;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Movable;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.elements.Tunnel;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.GraphicMinMax;
import de.neemann.digital.draw.graphics.GraphicSwing;
import de.neemann.digital.draw.graphics.GraphicTransform;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Transform;
import de.neemann.digital.draw.graphics.TransformMatrix;
import de.neemann.digital.draw.graphics.TransformRotate;
import de.neemann.digital.draw.graphics.TransformTranslate;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.shapes.Drawable;
import de.neemann.digital.draw.shapes.InteractorInterface;
import de.neemann.digital.draw.shapes.Shape;
import de.neemann.digital.draw.shapes.ShapeFactory;
import de.neemann.digital.draw.shapes.ShapeSpecificMatch;
import de.neemann.digital.gui.components.CircuitComponent;
import de.neemann.gui.Screen;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;

public class VisualElement
implements Drawable,
Movable,
AttributeListener {
    private static final int PIN = 2;
    private transient GraphicMinMax minMax;
    private transient GraphicMinMax minMaxText;
    private transient IOState ioState;
    private transient InteractorInterface interactor;
    private transient Element element;
    private transient Shape shape;
    private transient ShapeFactory shapeFactory;
    private transient Transform transform;
    private String elementName;
    private final ElementAttributes elementAttributes;
    private Vector pos;

    public VisualElement(String elementName) {
        this.elementName = elementName;
        this.elementAttributes = new ElementAttributes();
        this.setPos(new Vector(0, 0));
    }

    public VisualElement(VisualElement proto) {
        this.elementName = proto.elementName;
        this.elementAttributes = new ElementAttributes(proto.elementAttributes);
        this.setPos(new Vector(proto.pos));
        this.shapeFactory = proto.shapeFactory;
    }

    public String getElementName() {
        return this.elementName;
    }

    public <V> VisualElement setAttribute(Key<V> key, V val) {
        this.elementAttributes.set(key, val);
        return this;
    }

    public ElementAttributes getElementAttributes() {
        this.elementAttributes.addListener(this);
        return this.elementAttributes;
    }

    @Override
    public void attributeChanged() {
        this.resetShape();
    }

    private void resetShape() {
        this.shape = null;
        this.resetGeometry();
    }

    private void resetGeometry() {
        this.transform = null;
        this.minMax = null;
        this.minMaxText = null;
    }

    @Override
    public Vector getPos() {
        return this.pos;
    }

    public VisualElement setPos(Vector pos) {
        this.pos = this.elementAttributes.get(Keys.SNAP_TO_GRID) != false ? CircuitComponent.raster(pos) : pos;
        this.resetGeometry();
        return this;
    }

    public boolean matches(Vector p, boolean includeText) {
        if (this.getShape() instanceof ShapeSpecificMatch) {
            return ((ShapeSpecificMatch)this.getShape()).matches(this.getTransform().invert().transform(p));
        }
        GraphicMinMax m = this.getMinMax(includeText);
        return m.getMin().x <= p.x && m.getMin().y <= p.y && p.x <= m.getMax().x && p.y <= m.getMax().y;
    }

    public boolean matches(Vector min, Vector max) {
        GraphicMinMax m = this.getMinMax(false);
        return min.x <= m.getMin().x && m.getMax().x <= max.x && min.y <= m.getMin().y && m.getMax().y <= max.y;
    }

    public int getRotate() {
        return this.elementAttributes.get(Keys.ROTATE).getRotation();
    }

    public Shape getShape() {
        if (this.shape == null) {
            this.shape = this.shapeFactory.getShape(this.elementName, this.elementAttributes);
            this.resetGeometry();
        }
        return this.shape;
    }

    @Override
    public void drawTo(Graphic graphic, Style highLight) {
        this.drawShape(graphic, highLight);
        if (highLight != null) {
            GraphicMinMax mm = this.getMinMax(false);
            Vector delta = mm.getMax().sub(mm.getMin()).add(20, 20).div(2);
            Vector pos = mm.getMax().add(mm.getMin()).div(2);
            graphic.drawCircleHighlight(pos.sub(delta), pos.add(delta), highLight);
        }
    }

    private void drawShape(Graphic graphic, Style highLight) {
        GraphicTransform gr = new GraphicTransform(graphic, this.getTransform());
        Shape shape = this.getShape();
        shape.drawTo(gr, highLight);
        if (!graphic.isFlagSet(Graphic.Flag.noPinMarker)) {
            for (Pin p : shape.getPins()) {
                ((Graphic)gr).drawCircle(p.getPos().add(-2, -2), p.getPos().add(2, 2), p.getDirection() == PinDescription.Direction.input ? Style.WIRE : Style.WIRE_OUT);
            }
        }
    }

    private Transform getTransform() {
        if (this.transform == null) {
            int rotate = this.getRotate();
            this.transform = rotate == 0 ? new TransformTranslate(this.pos) : new TransformRotate(this.pos, rotate);
            if (this.elementAttributes.get(Keys.MIRROR).booleanValue()) {
                this.transform = Transform.mul(new TransformMatrix(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f), this.transform);
            }
        }
        return this.transform;
    }

    public GraphicMinMax getMinMax(boolean includeText) {
        if (includeText) {
            if (this.minMaxText == null) {
                GraphicMinMax mm = new GraphicMinMax(true, null);
                this.drawShape(mm, null);
                this.minMaxText = mm;
            }
            return this.minMaxText;
        }
        if (this.minMax == null) {
            GraphicMinMax mm = new GraphicMinMax(false, null);
            this.drawShape(mm, null);
            this.minMax = mm;
        }
        return this.minMax;
    }

    @Override
    public void move(Vector delta) {
        this.setPos(this.pos.add(delta));
    }

    public ImageIcon createIcon(int maxHeight) {
        float scaling = Screen.getInstance().getScaling();
        BufferedImage bi = this.getBufferedImage(0.5 * (double)scaling, (int)((float)maxHeight * scaling));
        return new ImageIcon(bi);
    }

    public BufferedImage getBufferedImage(double scale, int maxHeight) {
        GraphicMinMax mm = new GraphicMinMax();
        this.drawShape(mm, null);
        if ((double)(mm.getMax().y - mm.getMin().y) > (double)maxHeight / scale) {
            scale = (double)(maxHeight - 1) / (double)(mm.getMax().y - mm.getMin().y + 4);
        }
        int width = (int)Math.round((double)(mm.getMax().x - mm.getMin().x + 4) * scale + 1.0);
        int height = (int)Math.round((double)(mm.getMax().y - mm.getMin().y + 4) * scale + 1.0);
        BufferedImage bi = new BufferedImage(width, height, 2);
        Graphics2D gr = bi.createGraphics();
        gr.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        gr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gr.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        gr.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        gr.setColor(new Color(255, 255, 255, 0));
        gr.fillRect(0, 0, bi.getWidth(), bi.getHeight());
        gr.scale(scale, scale);
        gr.translate(2 - mm.getMin().x, 2 - mm.getMin().y);
        GraphicSwing grs = new GraphicSwing(gr);
        this.drawTo(grs, null);
        return bi;
    }

    public Pins getPins() {
        Shape shape = this.getShape();
        Transform tr = this.getTransform();
        Pins pins = shape.getPins();
        Pins transformedPins = new Pins();
        for (Pin p : pins) {
            transformedPins.add(new Pin(tr.transform(p.getPos()), p).setVisualElement(this));
        }
        return transformedPins;
    }

    public void setState(IOState ioState) {
        this.ioState = ioState;
        if (ioState == null) {
            this.interactor = null;
            this.resetShape();
        } else {
            this.interactor = this.getShape().applyStateMonitor(ioState);
        }
    }

    public void elementClicked(CircuitComponent cc, Point pos, Vector posInComponent, SyncAccess modelSync) {
        if (this.interactor != null) {
            this.interactor.clicked(cc, pos, this.ioState, this.element, modelSync);
        }
    }

    public void elementPressed(CircuitComponent cc, Point pos, Vector posInComponent, SyncAccess modelSync) {
        if (this.interactor != null) {
            this.interactor.pressed(cc, pos, this.ioState, this.element, modelSync);
        }
    }

    public void elementReleased(CircuitComponent cc, Point pos, Vector posInComponent, SyncAccess modelSync) {
        if (this.interactor != null) {
            this.interactor.released(cc, pos, this.ioState, this.element, modelSync);
        }
    }

    public void elementDragged(CircuitComponent cc, Point pos, Vector posInComponent, SyncAccess modelSync) {
        if (this.interactor != null) {
            this.interactor.dragged(cc, pos, posInComponent, this.getTransform(), this.ioState, this.element, modelSync);
        }
    }

    public String toString() {
        if (this.elementName.equals(Const.DESCRIPTION.getName())) {
            return String.valueOf(this.elementName) + " (" + this.elementAttributes.getValueFormatter().formatToView(new Value(this.elementAttributes.get(Keys.VALUE), this.elementAttributes.getBits())) + ")";
        }
        if (this.elementName.equals(Tunnel.DESCRIPTION.getName())) {
            return String.valueOf(this.elementName) + " (" + this.elementAttributes.get(Keys.NETNAME) + ")";
        }
        String label = this.elementAttributes.getLabel();
        if (label.isEmpty()) {
            return this.elementName;
        }
        return String.valueOf(this.elementName) + " (" + label + ")";
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public VisualElement setShapeFactory(ShapeFactory shapeFactory) {
        this.shapeFactory = shapeFactory;
        return this;
    }

    public boolean equalsDescription(ElementTypeDescription description) {
        return this.elementName.equals(description.getName());
    }

    public void rotate() {
        int rotate = this.getRotate();
        if (++rotate > 3) {
            rotate -= 4;
        }
        this.getElementAttributes().set(Keys.ROTATE, new Rotation(rotate));
    }

    public VisualElement setRotation(int rotation) {
        this.getElementAttributes().set(Keys.ROTATE, new Rotation(rotation));
        return this;
    }

    public boolean isInteractive() {
        return this.interactor != null;
    }

    public void setElementName(String elementName) {
        this.elementName = elementName;
    }

    public boolean isPinPos(Vector pos) {
        return this.getPinAt(pos) != null;
    }

    public Pin getPinAt(Vector pos) {
        for (Pin p : this.getPins()) {
            if (!p.getPos().equals(pos)) continue;
            return p;
        }
        return null;
    }
}

