/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.graphics;

import de.neemann.digital.draw.graphics.Transform;
import de.neemann.digital.draw.graphics.TransformMatrix;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.graphics.VectorFloat;
import de.neemann.digital.draw.graphics.VectorInterface;

public class TransformRotate
implements Transform {
    private final int sin;
    private final int cos;
    private final VectorInterface translation;

    public TransformRotate(VectorInterface translation, int rot) {
        this.translation = translation;
        switch (rot) {
            case 1: {
                this.sin = 1;
                this.cos = 0;
                break;
            }
            case 2: {
                this.sin = 0;
                this.cos = -1;
                break;
            }
            case 3: {
                this.sin = -1;
                this.cos = 0;
                break;
            }
            default: {
                this.sin = 0;
                this.cos = 1;
            }
        }
    }

    @Override
    public Vector transform(Vector v) {
        return new Vector(v.getX() * this.cos + v.getY() * this.sin + this.translation.getX(), -v.getX() * this.sin + v.getY() * this.cos + this.translation.getY());
    }

    @Override
    public VectorFloat transform(VectorFloat v) {
        return new VectorFloat(v.getXFloat() * (float)this.cos + v.getYFloat() * (float)this.sin + this.translation.getXFloat(), -v.getXFloat() * (float)this.sin + v.getYFloat() * (float)this.cos + this.translation.getYFloat());
    }

    @Override
    public TransformMatrix getMatrix() {
        return new TransformMatrix(this.cos, this.sin, -this.sin, this.cos, this.translation.getXFloat(), this.translation.getYFloat());
    }
}

