/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.graphics;

import de.neemann.digital.draw.graphics.Transform;
import de.neemann.digital.draw.graphics.VectorFloat;
import de.neemann.digital.draw.graphics.VectorInterface;
import java.util.ArrayList;
import java.util.List;

public class Vector
implements VectorInterface {
    public final int x;
    public final int y;

    public Vector(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Vector(VectorInterface pos) {
        this(pos.getX(), pos.getY());
    }

    public static Vector vec(int x, int y) {
        return new Vector(x, y);
    }

    public static Vector min(VectorInterface ... p) {
        int x = p[0].getX();
        int y = p[0].getY();
        int i = 1;
        while (i < p.length) {
            if (p[i].getX() < x) {
                x = p[i].getX();
            }
            if (p[i].getY() < y) {
                y = p[i].getY();
            }
            ++i;
        }
        return new Vector(x, y);
    }

    public static Vector max(VectorInterface ... p) {
        int x = p[0].getX();
        int y = p[0].getY();
        int i = 1;
        while (i < p.length) {
            if (p[i].getX() > x) {
                x = p[i].getX();
            }
            if (p[i].getY() > y) {
                y = p[i].getY();
            }
            ++i;
        }
        return new Vector(x, y);
    }

    public static Vector width(VectorInterface ... p) {
        int x1 = p[0].getX();
        int y1 = p[0].getY();
        int x2 = x1;
        int y2 = y1;
        int i = 1;
        while (i < p.length) {
            if (p[i].getX() < x1) {
                x1 = p[i].getX();
            }
            if (p[i].getY() < y1) {
                y1 = p[i].getY();
            }
            if (p[i].getX() > x2) {
                x2 = p[i].getX();
            }
            if (p[i].getY() > y2) {
                y2 = p[i].getY();
            }
            ++i;
        }
        return new Vector(x2 - x1, y2 - y1);
    }

    @Override
    public Vector add(VectorInterface a) {
        return new Vector(this.x + a.getX(), this.y + a.getY());
    }

    public Vector add(int x, int y) {
        return new Vector(this.x + x, this.y + y);
    }

    public static List<Vector> add(List<Vector> vectors, Vector offs) {
        ArrayList<Vector> newVec = new ArrayList<Vector>();
        for (Vector v : vectors) {
            newVec.add(v.add(offs));
        }
        return newVec;
    }

    @Override
    public Vector sub(VectorInterface a) {
        return new Vector(this.x - a.getX(), this.y - a.getY());
    }

    public Vector mul(int a) {
        return new Vector(this.x * a, this.y * a);
    }

    @Override
    public VectorFloat mul(float a) {
        return new VectorFloat((float)this.x * a, (float)this.y * a);
    }

    @Override
    public Vector div(int d) {
        return new Vector(this.x / d, this.y / d);
    }

    public String toString() {
        return "(x=" + this.x + ", y=" + this.y + ')';
    }

    public boolean inside(Vector min, Vector max) {
        return min.x <= this.x && this.x <= max.x && min.y <= this.y && this.y <= max.y;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vector vector = (Vector)o;
        return this.x == vector.x && this.y == vector.y;
    }

    public int hashCode() {
        int result = this.x;
        result = 31 * result + this.y;
        return result;
    }

    public boolean isZero() {
        return this.x == 0 && this.y == 0;
    }

    @Override
    public VectorFloat norm() {
        float l = (float)Math.sqrt(this.x * this.x + this.y * this.y);
        return new VectorFloat((float)this.x / l, (float)this.y / l);
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public float getXFloat() {
        return this.x;
    }

    @Override
    public float getYFloat() {
        return this.y;
    }

    @Override
    public VectorInterface transform(Transform tr) {
        return tr.transform(this);
    }

    @Override
    public Vector round() {
        return this;
    }

    @Override
    public float len() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y);
    }

    @Override
    public VectorFloat toFloat() {
        return new VectorFloat(this.x, this.y);
    }

    @Override
    public Vector getOrthogonal() {
        return new Vector(this.y, -this.x);
    }
}

