/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.model;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.ModelEvent;
import de.neemann.digital.core.ModelEventType;
import de.neemann.digital.core.ModelStateObserverTyped;
import de.neemann.digital.core.wiring.AsyncSeq;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class AsyncSequentialClock
implements ModelStateObserverTyped {
    private final Model model;
    private final ScheduledThreadPoolExecutor executor;
    private final int frequency;
    private RealTimeRunner runner;

    public AsyncSequentialClock(Model model, AsyncSeq asyncSeq, ScheduledThreadPoolExecutor executor) {
        this.model = model;
        this.executor = executor;
        int f = asyncSeq.getFrequency();
        if (f < 1) {
            f = 1;
        }
        this.frequency = f;
    }

    @Override
    public void handleEvent(ModelEvent event) {
        switch (event.getType()) {
            case STARTED: {
                int delayMuS = 1000000 / this.frequency;
                if (delayMuS < 100) {
                    delayMuS = 100;
                }
                this.runner = new RealTimeRunner(delayMuS);
                break;
            }
            case CLOSED: {
                if (this.runner == null) break;
                this.runner.stop();
            }
        }
    }

    @Override
    public ModelEventType[] getEvents() {
        return new ModelEventType[]{ModelEventType.STARTED, ModelEventType.CLOSED};
    }

    private class RealTimeRunner {
        private final ScheduledFuture<?> timer;

        RealTimeRunner(int delay) {
            this.timer = AsyncSequentialClock.this.executor.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    AsyncSequentialClock.this.model.doMicroStep(false);
                }
            }, delay, delay, TimeUnit.MICROSECONDS);
        }

        public void stop() {
            if (this.timer != null) {
                this.timer.cancel(false);
            }
        }
    }
}

