/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes;

import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Orientation;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.shapes.Interactor;
import de.neemann.digital.draw.shapes.Shape;

public class BreakShape
implements Shape {
    private static final int SIZE = 15;
    private static final int SIZEQ = 7;
    private static final Vector RAD = new Vector(15, 15);
    private static final Vector D1 = new Vector(7, -7);
    private static final Vector D2 = new Vector(7, 7);
    private final String label;
    private final PinDescriptions inputs;
    private final boolean enabled;

    public BreakShape(ElementAttributes attr, PinDescriptions inputs, PinDescriptions outputs) {
        this.inputs = inputs;
        this.label = attr.getLabel();
        this.enabled = attr.get(Keys.ENABLED);
    }

    @Override
    public Pins getPins() {
        return new Pins().add(new Pin(new Vector(0, 0), (PinDescription)this.inputs.get(0)));
    }

    @Override
    public Interactor applyStateMonitor(IOState ioState) {
        return null;
    }

    @Override
    public void drawTo(Graphic graphic, Style highLight) {
        Vector center = new Vector(17, 0);
        Style style = Style.NORMAL;
        if (!this.enabled) {
            style = Style.DISABLED;
        }
        graphic.drawCircle(center.sub(RAD), center.add(RAD), style);
        graphic.drawLine(center.sub(D1), center.add(D1), style);
        graphic.drawLine(center.sub(D2), center.add(D2), style);
        Vector textPos = new Vector(45, 0);
        graphic.drawText(textPos, this.label, Orientation.LEFTCENTER, style);
    }
}

