/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes;

import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Polygon;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.shapes.FETShape;
import java.awt.Color;

public class FGFETShapeN
extends FETShape {
    static final Style CHARGED_GATE = Style.NORMAL.deriveStyle(6, false, Color.RED);
    private final boolean programmed;

    public FGFETShapeN(ElementAttributes attributes, PinDescriptions inputs, PinDescriptions outputs) {
        super(attributes, inputs, outputs);
        this.programmed = attributes.get(Keys.BLOWN);
        this.setXOffs(11);
    }

    @Override
    public Pins getPins() {
        return new Pins().add(new Pin(new Vector(0, 40), (PinDescription)this.getInputs().get(0))).add(new Pin(new Vector(20, 0), (PinDescription)this.getOutputs().get(0))).add(new Pin(new Vector(20, 40), (PinDescription)this.getOutputs().get(1)));
    }

    @Override
    public void drawTo(Graphic graphic, Style highLight) {
        super.drawTo(graphic, highLight);
        if (this.programmed) {
            graphic.drawLine(new Vector(6, 36), new Vector(6, 4), CHARGED_GATE);
        } else {
            graphic.drawLine(new Vector(6, 36), new Vector(6, 4), Style.THIN);
        }
        graphic.drawLine(new Vector(18, 20), new Vector(23, 20), Style.THIN);
        graphic.drawPolygon(new Polygon(true).add(15, 20).add(20, 18).add(20, 22), Style.THIN_FILLED);
    }
}

