/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes;

import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.io.In;
import de.neemann.digital.core.io.Out;
import de.neemann.digital.core.wiring.Clock;
import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.elements.VisualElement;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Orientation;
import de.neemann.digital.draw.graphics.Polygon;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.library.ElementNotFoundException;
import de.neemann.digital.draw.library.ElementTypeDescriptionCustom;
import de.neemann.digital.draw.shapes.InteractorInterface;
import de.neemann.digital.draw.shapes.Shape;
import de.neemann.digital.lang.Lang;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public class LayoutShape
implements Shape {
    private final int width;
    private final int height;
    private final Pins pins;
    private final Color color;
    private final String name;
    private final PinList left;
    private final PinList right;
    private final PinList top;
    private final PinList bottom;

    public LayoutShape(ElementTypeDescriptionCustom custom, ElementAttributes elementAttributes) throws NodeException, PinException, ElementNotFoundException {
        String l = elementAttributes.getLabel();
        this.name = l != null && l.length() > 0 ? l : custom.getShortName();
        this.left = new PinList(this.name, false);
        this.right = new PinList(this.name, false);
        this.top = new PinList(this.name, true);
        this.bottom = new PinList(this.name, true);
        Circuit circuit = custom.getResolvedCircuit(elementAttributes);
        for (VisualElement ve : circuit.getElements()) {
            if (ve.equalsDescription(In.DESCRIPTION) || ve.equalsDescription(Clock.DESCRIPTION)) {
                switch (ve.getRotate()) {
                    case 0: {
                        this.left.add(ve);
                        break;
                    }
                    case 1: {
                        this.bottom.add(ve);
                        break;
                    }
                    case 2: {
                        this.right.add(ve);
                        break;
                    }
                    default: {
                        this.top.add(ve);
                    }
                }
            }
            if (!ve.equalsDescription(Out.DESCRIPTION)) continue;
            switch (ve.getRotate()) {
                case 0: {
                    this.right.add(ve);
                    break;
                }
                case 1: {
                    this.top.add(ve);
                    break;
                }
                case 2: {
                    this.left.add(ve);
                    break;
                }
                default: {
                    this.bottom.add(ve);
                }
            }
        }
        this.height = this.left.max(this.right.max(circuit.getAttributes().get(Keys.HEIGHT)));
        this.width = this.top.max(this.bottom.max(circuit.getAttributes().get(Keys.WIDTH)));
        HashMap<String, PinPos> map = new HashMap<String, PinPos>();
        this.top.createPosition(map, new Vector(0, 0), this.width);
        this.bottom.createPosition(map, new Vector(0, 20 * this.height), this.width);
        this.left.createPosition(map, new Vector(0, 0), this.height);
        this.right.createPosition(map, new Vector(20 * this.width, 0), this.height);
        this.pins = new Pins();
        for (PinDescription p : custom.getInputDescription(elementAttributes)) {
            this.pins.add(this.createPin(map, p));
        }
        for (PinDescription p : custom.getOutputDescriptions(elementAttributes)) {
            this.pins.add(this.createPin(map, p));
        }
        this.color = circuit.getAttributes().get(Keys.BACKGROUND_COLOR);
    }

    private Pin createPin(HashMap<String, PinPos> map, PinDescription p) throws PinException {
        PinPos pinPos = map.get(p.getName());
        if (pinPos == null) {
            throw new PinException(Lang.get("err_pin_N_notFound", p.getName()));
        }
        return new Pin(pinPos.pos, p);
    }

    @Override
    public Pins getPins() {
        return this.pins;
    }

    @Override
    public InteractorInterface applyStateMonitor(IOState ioState) {
        return null;
    }

    @Override
    public void drawTo(Graphic graphic, Style highLight) {
        Polygon poly = new Polygon(true).add(0, 0).add(this.width * 20, 0).add(this.width * 20, this.height * 20).add(0, this.height * 20);
        graphic.drawPolygon(poly, Style.NORMAL.deriveFillStyle(this.color));
        graphic.drawPolygon(poly, Style.NORMAL);
        if (this.bottom.size() == 0) {
            graphic.drawText(new Vector(this.width * 20 / 2, this.height * 20 + 4), this.name, Orientation.CENTERTOP, Style.SHAPE_PIN);
        } else if (this.top.size() == 0) {
            graphic.drawText(new Vector(this.width * 20 / 2, -4), this.name, Orientation.CENTERBOTTOM, Style.SHAPE_PIN);
        } else {
            graphic.drawText(new Vector(this.width * 20 / 2, this.height * 20 / 2), this.name, Orientation.CENTERCENTER, Style.SHAPE_PIN);
        }
        for (PinPos p : this.left) {
            graphic.drawText(p.pos.add(4, 0), p.label, Orientation.LEFTCENTER, Style.SHAPE_PIN);
        }
        for (PinPos p : this.right) {
            graphic.drawText(p.pos.add(-4, 0), p.label, Orientation.RIGHTCENTER, Style.SHAPE_PIN);
        }
        for (PinPos p : this.top) {
            graphic.drawText(p.pos.add(0, 4), p.pos.add(0, 3), p.label, Orientation.RIGHTCENTER, Style.SHAPE_PIN);
        }
        for (PinPos p : this.bottom) {
            graphic.drawText(p.pos.add(0, -4), p.pos.add(0, -3), p.label, Orientation.RIGHTCENTER, Style.SHAPE_PIN);
        }
    }

    private static final class PinList
    implements Iterable<PinPos> {
        private final String name;
        private final boolean horizontal;
        private ArrayList<PinPos> pins;
        private boolean allHavePosDeltas = false;
        private Vector pos;
        private int minWidth;

        private PinList(String name, boolean horizontal) {
            this.name = name;
            this.horizontal = horizontal;
            this.pins = new ArrayList();
        }

        private void add(VisualElement ve) {
            PinPos pp = new PinPos(ve, this.horizontal);
            this.pins.add(pp);
            if (pp.hasPosDelta) {
                this.minWidth += pp.posDelta;
            } else {
                this.allHavePosDeltas = false;
            }
        }

        private int size() {
            return this.pins.size();
        }

        private void createPosition(HashMap<String, PinPos> map, Vector startPos, int length) throws PinException {
            this.pos = startPos;
            Collections.sort(this.pins);
            if (this.allHavePosDeltas) {
                for (PinPos pp : this.pins) {
                    this.move(pp.posDelta);
                    pp.pos = this.pos;
                    this.addToMap(map, pp);
                }
            } else {
                int delta = (length + 2) / (this.pins.size() + 1);
                int pinsOnly = delta * (this.pins.size() - 1);
                this.move((length - pinsOnly) / 2);
                for (PinPos pp : this.pins) {
                    pp.pos = this.pos;
                    this.addToMap(map, pp);
                    this.move(delta);
                }
            }
        }

        private void addToMap(HashMap<String, PinPos> map, PinPos pp) throws PinException {
            if (map.containsKey(pp.label)) {
                throw new PinException(Lang.get("err_duplicatePinLabel", pp.label, this.name));
            }
            map.put(pp.label, pp);
        }

        private void move(int delta) {
            this.pos = this.horizontal ? this.pos.add(20 * delta, 0) : this.pos.add(0, 20 * delta);
        }

        private int max(int m) {
            if (this.allHavePosDeltas) {
                m = Math.max(m, this.minWidth + 1);
            }
            return Math.max(m, this.pins.size() + 1);
        }

        @Override
        public Iterator<PinPos> iterator() {
            return this.pins.iterator();
        }
    }

    private static final class PinPos
    implements Comparable<PinPos> {
        private final int orderPos;
        private final String label;
        private boolean hasPosDelta;
        private int posDelta;
        private Vector pos;

        private PinPos(VisualElement ve, boolean horizontal) {
            this.orderPos = horizontal ? ve.getPos().x : ve.getPos().y;
            this.label = ve.getElementAttributes().getLabel();
            this.posDelta = ve.getElementAttributes().get(Keys.LAYOUT_SHAPE_DELTA);
            this.hasPosDelta = this.posDelta > 0;
        }

        @Override
        public int compareTo(PinPos pinPos) {
            return this.orderPos - pinPos.orderPos;
        }
    }
}

