/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes;

import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.Value;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Orientation;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.shapes.InteractorInterface;
import de.neemann.digital.draw.shapes.Shape;

public class LightBulbShape
implements Shape {
    private static final Vector CENTER = new Vector(0, 20);
    private static final int BORDER = 2;
    private static final int RAD = 11;
    private final PinDescriptions inputs;
    private final Style style;
    private final String label;
    private ObservableValue aValue;
    private ObservableValue bValue;
    private Value a;
    private Value b;

    public LightBulbShape(ElementAttributes attr, PinDescriptions inputs, PinDescriptions outputs) {
        this.inputs = inputs;
        this.style = Style.NORMAL.deriveFillStyle(attr.get(Keys.COLOR));
        this.label = attr.getLabel();
    }

    @Override
    public Pins getPins() {
        return new Pins().add(new Pin(new Vector(0, 0), (PinDescription)this.inputs.get(0))).add(new Pin(new Vector(0, 40), (PinDescription)this.inputs.get(1)));
    }

    @Override
    public InteractorInterface applyStateMonitor(IOState ioState) {
        this.aValue = ioState.getInput(0);
        this.bValue = ioState.getInput(1);
        return null;
    }

    @Override
    public void readObservableValues() {
        if (this.aValue != null && this.bValue != null) {
            this.a = this.aValue.getCopy();
            this.b = this.bValue.getCopy();
        }
    }

    @Override
    public void drawTo(Graphic graphic, Style highLight) {
        if (this.a != null && this.b != null) {
            boolean on;
            boolean bl = on = !this.a.isHighZ() && !this.b.isHighZ() && this.a.getBool() != this.b.getBool();
            if (on) {
                graphic.drawCircle(new Vector(-17, 3), new Vector(17, 37), this.style);
            }
        } else {
            graphic.drawLine(CENTER.add(-11, -11), CENTER.add(11, 11), Style.NORMAL);
            graphic.drawLine(CENTER.add(-11, 11), CENTER.add(11, -11), Style.NORMAL);
        }
        graphic.drawText(new Vector(30, 20), this.label, Orientation.LEFTCENTER, Style.NORMAL);
        graphic.drawCircle(new Vector(-18, 2), new Vector(18, 38), Style.NORMAL);
    }
}

