/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes;

import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.Value;
import de.neemann.digital.core.ValueFormatter;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.core.io.Probe;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Orientation;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.shapes.Interactor;
import de.neemann.digital.draw.shapes.Shape;

public class ProbeShape
implements Shape {
    private final String label;
    private final PinDescriptions inputs;
    private final ValueFormatter formatter;
    private final boolean isLabel;
    private ObservableValue inValue;
    private Value inValueCopy;

    public ProbeShape(ElementAttributes attr, PinDescriptions inputs, PinDescriptions outputs) {
        this.inputs = inputs;
        this.label = attr.getLabel();
        this.isLabel = this.label != null && this.label.length() > 0;
        this.formatter = attr.getValueFormatter();
    }

    @Override
    public Pins getPins() {
        return new Pins().add(new Pin(new Vector(0, 0), (PinDescription)this.inputs.get(0)));
    }

    @Override
    public Interactor applyStateMonitor(IOState ioState) {
        this.inValue = ((Probe)ioState.getElement()).getValue();
        return null;
    }

    @Override
    public void readObservableValues() {
        if (this.inValue != null) {
            this.inValueCopy = this.inValue.getCopy();
        }
    }

    @Override
    public void drawTo(Graphic graphic, Style highLight) {
        int dy = -1;
        Orientation orientation = Orientation.LEFTCENTER;
        if (this.isLabel) {
            graphic.drawText(new Vector(2, -4), this.label, Orientation.LEFTBOTTOM, Style.NORMAL);
            dy = 4;
            orientation = Orientation.LEFTTOP;
        }
        String v = "?";
        if (this.inValueCopy != null) {
            v = this.formatter.formatToView(this.inValueCopy);
        }
        graphic.drawText(new Vector(2, dy), v, orientation, Style.NORMAL);
    }
}

