/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes;

import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Orientation;
import de.neemann.digital.draw.graphics.Polygon;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.shapes.Interactor;
import de.neemann.digital.draw.shapes.Shape;

public class ResetShape
implements Shape {
    private final String label;
    private final PinDescriptions outputs;
    private final boolean invOut;

    public ResetShape(ElementAttributes attr, PinDescriptions inputs, PinDescriptions outputs) {
        this.outputs = outputs;
        this.label = attr.getLabel();
        this.invOut = attr.get(Keys.INVERT_OUTPUT);
    }

    @Override
    public Pins getPins() {
        return new Pins().add(new Pin(new Vector(0, 0), (PinDescription)this.outputs.get(0)));
    }

    @Override
    public Interactor applyStateMonitor(IOState ioState) {
        return null;
    }

    @Override
    public void drawTo(Graphic graphic, Style highLight) {
        int x = 0;
        if (this.invOut) {
            x -= 19;
            graphic.drawCircle(new Vector(-19, -9), new Vector(-1, 9), Style.NORMAL);
        }
        graphic.drawPolygon(new Polygon(true).add(x - 30 - 2, -15).add(x - 2, -15).add(x - 2, 15).add(x - 30 - 2, 15), Style.NORMAL);
        Vector textPos = new Vector(x - 30 + 2, -13);
        graphic.drawText(textPos, "R", Orientation.LEFTTOP, Style.SHAPE_PIN);
        textPos = new Vector(x - 45, 0);
        graphic.drawText(textPos, this.label, Orientation.RIGHTCENTER, Style.NORMAL);
    }
}

