/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes;

import de.neemann.digital.core.SyncAccess;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.core.switching.SwitchDT;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Orientation;
import de.neemann.digital.draw.graphics.Polygon;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.shapes.Interactor;
import de.neemann.digital.draw.shapes.InteractorInterface;
import de.neemann.digital.draw.shapes.Shape;
import de.neemann.digital.gui.components.CircuitComponent;
import java.awt.Point;

public class SwitchDTShape
implements Shape {
    private final PinDescriptions outputs;
    private final String label;
    private final int poles;
    private boolean closed;

    public SwitchDTShape(ElementAttributes attributes, PinDescriptions inputs, PinDescriptions outputs) {
        this.outputs = outputs;
        this.closed = attributes.get(Keys.CLOSED);
        this.poles = attributes.get(Keys.POLES);
        this.label = attributes.getLabel();
    }

    @Override
    public Pins getPins() {
        Pins pins = new Pins();
        int p = 0;
        while (p < this.poles) {
            pins.add(new Pin(new Vector(0, 40 * p), (PinDescription)this.outputs.get(p * 3))).add(new Pin(new Vector(40, 40 * p), (PinDescription)this.outputs.get(p * 3 + 1))).add(new Pin(new Vector(40, 20 + 40 * p), (PinDescription)this.outputs.get(p * 3 + 2)));
            ++p;
        }
        return pins;
    }

    @Override
    public InteractorInterface applyStateMonitor(IOState ioState) {
        return new Interactor(){

            @Override
            public void clicked(CircuitComponent cc, Point pos, IOState ioState, Element element, SyncAccess modelSync) {
                SwitchDTShape.this.closed = !SwitchDTShape.this.closed;
                if (ioState != null) {
                    modelSync.modify(() -> ((SwitchDT)element).setClosed(SwitchDTShape.this.closed));
                }
            }
        };
    }

    @Override
    public void drawTo(Graphic graphic, Style highLight) {
        int yOffs = 0;
        int p = 0;
        while (p < this.poles) {
            graphic.drawPolygon(new Polygon(false).add(40, p * 20 * 2 + 20).add(35, p * 20 * 2 + 20).add(35, p * 20 * 2 + 10 + 2), Style.NORMAL);
            ++p;
        }
        if (this.closed) {
            p = 0;
            while (p < this.poles) {
                graphic.drawLine(new Vector(0, 40 * p), new Vector(40, 40 * p), Style.NORMAL);
                ++p;
            }
        } else {
            yOffs = -5;
            p = 0;
            while (p < this.poles) {
                graphic.drawLine(new Vector(0, 40 * p), new Vector(36, 40 * p - yOffs * 2), Style.NORMAL);
                ++p;
            }
        }
        graphic.drawLine(new Vector(20, -yOffs + (this.poles - 1) * 2 * 20), new Vector(20, -yOffs - 20), Style.DASH);
        graphic.drawLine(new Vector(10, -yOffs - 20), new Vector(30, -yOffs - 20), Style.THIN);
        if (this.label != null && this.label.length() > 0) {
            graphic.drawText(new Vector(20, 4 + (this.poles - 1) * 2 * 20 + 20), this.label, Orientation.CENTERTOP, Style.SHAPE_PIN);
        }
    }
}

