/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes;

import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.graphics.ColorKey;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Orientation;
import de.neemann.digital.draw.graphics.Polygon;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.shapes.InteractorInterface;
import de.neemann.digital.draw.shapes.Shape;

public class TestCaseShape
implements Shape {
    private static final Style TESTSTYLE = Style.NORMAL.deriveFillStyle(ColorKey.TESTCASE);
    private final String label;
    private final boolean enabled;

    public TestCaseShape(ElementAttributes attributes, PinDescriptions inputs, PinDescriptions outputs) {
        this.label = attributes.getLabel();
        this.enabled = attributes.get(Keys.ENABLED);
    }

    @Override
    public Pins getPins() {
        return new Pins();
    }

    @Override
    public InteractorInterface applyStateMonitor(IOState ioState) {
        return null;
    }

    @Override
    public void drawTo(Graphic graphic, Style highLight) {
        if (!graphic.isFlagSet(Graphic.Flag.hideTest)) {
            Polygon pol = new Polygon(true).add(10, 10).add(90, 10).add(90, 50).add(10, 50);
            Style textStyle = Style.NORMAL;
            if (this.enabled) {
                graphic.drawPolygon(pol, TESTSTYLE);
                graphic.drawPolygon(pol, Style.THIN);
            } else {
                graphic.drawPolygon(pol, Style.DISABLED);
                textStyle = Style.DISABLED;
            }
            graphic.drawText(new Vector(50, 30), "Test", Orientation.CENTERCENTER, textStyle);
            graphic.drawText(new Vector(50, 0), this.label, Orientation.CENTERBOTTOM, textStyle);
        }
    }
}

