/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes.custom;

import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Orientation;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.shapes.Drawable;
import de.neemann.digital.draw.shapes.InteractorInterface;
import de.neemann.digital.draw.shapes.Shape;
import de.neemann.digital.draw.shapes.custom.CustomShapeDescription;

public class CustomShape
implements Shape {
    private final String label;
    private final CustomShapeDescription shapeDescription;
    private final PinDescriptions inputs;
    private final PinDescriptions outputs;
    private Pins pins;

    public CustomShape(CustomShapeDescription shapeDescription, String label, PinDescriptions inputs, PinDescriptions outputs) throws PinException {
        this.label = label;
        this.shapeDescription = shapeDescription;
        this.inputs = inputs;
        this.outputs = outputs;
        this.initPins();
    }

    private void initPins() throws PinException {
        this.pins = new Pins();
        for (PinDescription p : this.outputs) {
            this.pins.add(new Pin(this.shapeDescription.getPin(p.getName()).getPos(), p));
        }
        for (PinDescription p : this.inputs) {
            this.pins.add(new Pin(this.shapeDescription.getPin(p.getName()).getPos(), p));
        }
    }

    @Override
    public Pins getPins() {
        return this.pins;
    }

    @Override
    public InteractorInterface applyStateMonitor(IOState ioState) {
        return null;
    }

    @Override
    public void drawTo(Graphic graphic, Style highLight) {
        for (Drawable d : this.shapeDescription) {
            d.drawTo(graphic, highLight);
        }
        CustomShapeDescription.TextHolder l = this.shapeDescription.getLabel();
        if (l != null && this.label != null && !this.label.isEmpty()) {
            l.drawText(graphic, this.label);
        }
        for (Pin p : this.getPins()) {
            try {
                CustomShapeDescription.Pin cp = this.shapeDescription.getPin(p.getName());
                if (cp == null || !cp.isShowLabel()) continue;
                if (p.getDirection() == PinDescription.Direction.input) {
                    graphic.drawText(p.getPos().add(4, 0), p.getName(), Orientation.LEFTCENTER, Style.SHAPE_PIN);
                    continue;
                }
                graphic.drawText(p.getPos().add(-4, 0), p.getName(), Orientation.RIGHTCENTER, Style.SHAPE_PIN);
            }
            catch (PinException pinException) {
                // empty catch block
            }
        }
    }
}

