/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes.custom.svg;

import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import java.awt.Color;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;

public class SvgTemplate
implements Closeable {
    private final Writer w;
    private final PinDescription[] inputs;
    private final ObservableValues outputs;
    private final int width;
    private final int height;

    public SvgTemplate(File file, Circuit circuit) throws Exception {
        this(new FileOutputStream(file), circuit);
    }

    public SvgTemplate(OutputStream outputStream, Circuit circuit) throws Exception {
        this.width = circuit.getAttributes().get(Keys.WIDTH) * 20;
        this.inputs = circuit.getInputNames();
        this.outputs = circuit.getOutputNames();
        this.height = Math.max(this.inputs.length, this.outputs.size()) * 20;
        int border = 80;
        this.w = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
        this.w.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<svg\n   xmlns:dc=\"http://purl.org/dc/elements/1.1/\"\n   xmlns:cc=\"http://creativecommons.org/ns#\"\n   xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n   xmlns:svg=\"http://www.w3.org/2000/svg\"\n   xmlns=\"http://www.w3.org/2000/svg\"\n   xmlns:sodipodi=\"http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd\"\n   xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\"\n   viewBox=\"-" + border + " -" + border + " " + (this.width + border * 2) + " " + (this.height - 20 + border * 2) + "\"\n" + "   version=\"1.1\">\n" + "  <sodipodi:namedview showgrid=\"true\">\n" + "    <inkscape:grid\n" + "       type=\"xygrid\"\n" + "       empspacing=\"4\"\n" + "       spacingx=\"5\"\n" + "       spacingy=\"5\" />\n" + "  </sodipodi:namedview>\n");
    }

    public void create() throws Exception {
        this.w.write("  <rect stroke=\"black\" stroke-width=\"4\" fill=\"" + this.getColor(Keys.BACKGROUND_COLOR.getDefault()) + "\"" + " fill-opacity=\"" + (float)Keys.BACKGROUND_COLOR.getDefault().getAlpha() / 255.0f + "\"" + " x=\"0\" y=\"-10\" width=\"" + this.width + "\" height=\"" + this.height + "\"/>\n");
        Style style = Style.NORMAL;
        this.w.write("    <text id=\"label\" fill=\"" + this.getColor(style) + "\" font-size=\"" + style.getFontSize() + "\" text-anchor=\"middle\" x=\"" + this.width / 2 + "\" y=\"" + -20 + "\">Label</text>\n");
        style = Style.SHAPE_PIN;
        int yOffs = style.getFontSize() / 3;
        int y = 0;
        PinDescription[] pinDescriptionArray = this.inputs;
        int n = this.inputs.length;
        int n2 = 0;
        while (n2 < n) {
            PinDescription i = pinDescriptionArray[n2];
            this.w.write("  <g>\n");
            this.w.write("    <circle fill=\"" + this.getColor(Style.WIRE) + "\" id=\"pin:" + i.getName() + "\" cx=\"0\" cy=\"" + y + "\" r=\"3\"/>\n");
            Vector labelPos = new Vector(4, y + yOffs);
            this.w.write("    <text fill=\"" + this.getColor(style) + "\" font-size=\"" + style.getFontSize() + "\" x=\"" + labelPos.getX() + "\" y=\"" + labelPos.getY() + "\">" + i.getName() + "</text>\n");
            this.w.write("  </g>\n");
            y += 20;
            ++n2;
        }
        y = 0;
        for (PinDescription o : this.outputs) {
            this.w.write("  <g>\n");
            this.w.write("    <circle fill=\"" + this.getColor(Style.WIRE_OUT) + "\" id=\"pin:" + o.getName() + "\" cx=\"" + this.width + "\" cy=\"" + y + "\" r=\"3\"/>\n");
            Vector labelPos = new Vector(this.width - 4, y + yOffs);
            this.w.write("    <text fill=\"" + this.getColor(style) + "\" font-size=\"" + style.getFontSize() + "\" text-anchor=\"end\" x=\"" + labelPos.getX() + "\" y=\"" + labelPos.getY() + "\">" + o.getName() + "</text>\n");
            this.w.write("  </g>\n");
            y += 20;
        }
    }

    private String getColor(Style style) {
        return this.getColor(style.getColor());
    }

    private String getColor(Color color) {
        return "#" + Integer.toHexString(color.getRGB()).substring(2);
    }

    @Override
    public void close() throws IOException {
        this.w.write("</svg>\n");
        this.w.close();
    }
}

