/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.fsm;

import de.neemann.digital.analyse.ModelAnalyserInfo;
import de.neemann.digital.analyse.TruthTable;
import de.neemann.digital.analyse.expression.ContextMap;
import de.neemann.digital.analyse.expression.ExpressionException;
import de.neemann.digital.analyse.expression.Variable;
import de.neemann.digital.analyse.expression.VariableVisitor;
import de.neemann.digital.core.Signal;
import de.neemann.digital.fsm.CircuitRepresentation;
import de.neemann.digital.fsm.FSM;
import de.neemann.digital.fsm.FiniteStateMachineException;
import de.neemann.digital.fsm.Movable;
import de.neemann.digital.fsm.State;
import de.neemann.digital.fsm.Transition;
import de.neemann.digital.fsm.ValueParser;
import de.neemann.digital.lang.Lang;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;

public class TransitionTableCreator {
    private static final String STATE_VAR = "Z";
    private final List<State> states;
    private final List<Transition> transitions;
    private final HashMap<Movable, TreeMap<String, Integer>> outputValues;
    private final ArrayList<Signal> inputSignals;
    private final ArrayList<Signal> outputSignals;
    private final int initState;
    private TruthTable truthTable;
    private int rowsPerState;
    private ArrayList<Variable> inVars;
    private int stateBits;
    private boolean[] transitionSet;
    private ModelAnalyserInfo modelAnalyserInfo;
    private CircuitRepresentation cr;

    TransitionTableCreator(FSM fsm) throws FiniteStateMachineException {
        this(fsm, null);
    }

    TransitionTableCreator(FSM fsm, String stateSignalName) throws FiniteStateMachineException {
        this.states = fsm.getStates();
        this.transitions = fsm.getTransitions();
        this.initState = fsm.getInitState();
        this.cr = new CircuitRepresentation();
        fsm.setCircuitRepresentation(this.cr);
        this.outputValues = new HashMap();
        this.modelAnalyserInfo = new ModelAnalyserInfo(null);
        this.modelAnalyserInfo.setStateSignalName(stateSignalName);
        this.inputSignals = new ArrayList();
        this.outputSignals = new ArrayList();
    }

    private TreeMap<String, Integer> getValues(Movable m) throws FiniteStateMachineException {
        TreeMap<String, Integer> values = this.outputValues.get(m);
        if (values == null) {
            values = new ValueParser(m.getValues()).setModelAnalyzerInfo(this.modelAnalyserInfo).parse();
            this.outputValues.put(m, values);
        }
        return values;
    }

    public TruthTable create() throws FiniteStateMachineException, ExpressionException {
        this.stateBits = this.getStateVarBits();
        this.cr.setStateVarBits(this.stateBits);
        ArrayList<Variable> vars = new ArrayList<Variable>();
        ArrayList<String> maiNames = new ArrayList<String>();
        int i = this.stateBits - 1;
        while (i >= 0) {
            Variable var = new Variable("Z_" + i + "^n");
            maiNames.add(0, var.getIdentifier());
            vars.add(var);
            boolean initVal = (this.initState & 1 << i) != 0;
            this.modelAnalyserInfo.setSequentialInitValue(var.getIdentifier(), initVal ? 1 : 0);
            --i;
        }
        this.truthTable = new TruthTable(vars);
        i = this.stateBits - 1;
        while (i >= 0) {
            this.truthTable.addResult("Z_" + i + "^{n+1}");
            --i;
        }
        TreeSet<String> results = new TreeSet<String>();
        for (State s : this.states) {
            results.addAll(this.getValues(s).keySet());
        }
        for (Transition t : this.transitions) {
            results.addAll(this.getValues(t).keySet());
        }
        for (String name : results) {
            this.truthTable.addResult(name);
            this.outputSignals.add(new Signal(name, null));
        }
        this.truthTable.modifyValues(v -> 2);
        for (State s : this.states) {
            int row = s.getNumber();
            this.cr.addState(row, s);
            int col = this.stateBits * 2;
            for (String name : results) {
                int def = s.isDefaultDC() ? 2 : 0;
                Integer val = this.getValues(s).get(name);
                int v2 = val == null ? def : val;
                this.truthTable.setValue(row, col, v2);
                ++col;
            }
        }
        for (State s : this.states) {
            int row;
            int c = this.stateBits * 2;
            int m = row = s.getNumber();
            int j = 0;
            while (j < this.stateBits) {
                --c;
                int aValue = 2;
                if (!s.isDefaultDC()) {
                    aValue = m & 1;
                }
                this.truthTable.setValue(row, c, aValue);
                m >>= 1;
                ++j;
            }
        }
        VariableVisitor vv = new VariableVisitor();
        for (Transition t : this.transitions) {
            if (!t.hasCondition()) continue;
            t.getConditionExpression().traverse(vv);
        }
        this.inVars = new ArrayList<Variable>(vv.getVariables());
        for (Variable v3 : this.inVars) {
            this.truthTable.addVariable(v3);
            this.inputSignals.add(new Signal(v3.getIdentifier(), null));
            maiNames.add(v3.getIdentifier());
        }
        this.rowsPerState = 1 << this.inVars.size();
        this.transitionSet = new boolean[this.truthTable.getRows()];
        for (Transition t : this.transitions) {
            if (t.hasCondition()) continue;
            this.fillInTransition(t, results);
        }
        this.transitionSet = new boolean[this.truthTable.getRows()];
        for (Transition t : this.transitions) {
            if (!t.hasCondition()) continue;
            this.fillInTransition(t, results);
        }
        this.modelAnalyserInfo.setInOut(this.inputSignals, this.outputSignals);
        this.modelAnalyserInfo.setStateSignalBitNames(maiNames);
        this.truthTable.setModelAnalyzerInfo(this.modelAnalyserInfo);
        return this.truthTable;
    }

    private void fillInTransition(Transition t, TreeSet<String> results) throws ExpressionException, FiniteStateMachineException {
        int startState = t.getStartState().getNumber();
        int startRow = startState * this.rowsPerState;
        ContextMap c = new ContextMap();
        int r = 0;
        while (r < this.rowsPerState) {
            int transVal = 0;
            int transValMask = 1;
            int m = 1 << this.inVars.size() - 1;
            for (Variable v : this.inVars) {
                boolean b = (r & m) != 0;
                c.set(v, b);
                if (b) {
                    transVal |= transValMask;
                }
                m >>= 1;
                transValMask <<= 1;
            }
            if (!t.hasCondition() || t.getConditionExpression().calculate(c)) {
                int n = t.getStartState().getNumber();
                this.cr.addTransition(n |= transVal << this.stateBits, t);
                int col = this.stateBits * 2 + this.inVars.size();
                int row = startRow + r;
                this.checkRow(row, t);
                int mask = t.getTargetState().getNumber();
                int j = 0;
                while (j < this.stateBits) {
                    this.truthTable.setValue(row, --col, mask & 1);
                    mask >>= 1;
                    ++j;
                }
                TreeMap<String, Integer> valueMap = this.getValues(t);
                if (!valueMap.isEmpty()) {
                    col = this.stateBits * 2 + this.inVars.size();
                    for (String name : results) {
                        Integer val = valueMap.get(name);
                        if (val != null) {
                            this.truthTable.setValue(row, col, val);
                        }
                        ++col;
                    }
                }
            }
            ++r;
        }
    }

    private void checkRow(int row, Transition t) throws FiniteStateMachineException {
        if (this.transitionSet[row]) {
            throw new FiniteStateMachineException(Lang.get("err_notDeterministic_N", t.toString()));
        }
        this.transitionSet[row] = true;
    }

    private int getStateVarBits() throws FiniteStateMachineException {
        HashSet<Integer> numbers = new HashSet<Integer>();
        int maxNumber = 0;
        for (State s : this.states) {
            int n = s.getNumber();
            if (n > maxNumber) {
                maxNumber = n;
            }
            if (numbers.contains(n)) {
                throw new FiniteStateMachineException(Lang.get("err_fsmNumberUsedTwice_N", n));
            }
            numbers.add(n);
        }
        int n = 1;
        while (1 << n <= maxNumber) {
            ++n;
        }
        return n;
    }
}

