/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.fsm.gui;

import de.neemann.digital.FileLocator;
import de.neemann.digital.analyse.expression.ExpressionException;
import de.neemann.digital.analyse.expression.format.FormatterException;
import de.neemann.digital.core.GlobalValues;
import de.neemann.digital.core.Model;
import de.neemann.digital.core.ModelEvent;
import de.neemann.digital.core.ModelEventType;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.draw.graphics.ExportFactory;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.GraphicMinMax;
import de.neemann.digital.draw.graphics.GraphicSVG;
import de.neemann.digital.draw.library.ElementLibrary;
import de.neemann.digital.draw.shapes.ShapeFactory;
import de.neemann.digital.fsm.FSM;
import de.neemann.digital.fsm.FSMDemos;
import de.neemann.digital.fsm.FiniteStateMachineException;
import de.neemann.digital.fsm.State;
import de.neemann.digital.fsm.gui.FSMComponent;
import de.neemann.digital.fsm.gui.OptimizerDialog;
import de.neemann.digital.gui.FileHistory;
import de.neemann.digital.gui.Main;
import de.neemann.digital.gui.SaveAsHelper;
import de.neemann.digital.gui.Settings;
import de.neemann.digital.gui.WindowManager;
import de.neemann.digital.gui.components.table.ShowStringDialog;
import de.neemann.digital.gui.components.table.TableDialog;
import de.neemann.digital.lang.Lang;
import de.neemann.gui.ClosingWindowListener;
import de.neemann.gui.ErrorMessage;
import de.neemann.gui.IconCreator;
import de.neemann.gui.InfoDialog;
import de.neemann.gui.MyFileChooser;
import de.neemann.gui.ToolTipAction;
import de.neemann.gui.WindowSizeStorage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.filechooser.FileNameExtensionFilter;

public class FSMFrame
extends JFrame
implements ClosingWindowListener.ConfirmSave,
FSM.ModifiedListener,
FileHistory.OpenInterface {
    private static final Preferences PREFS = Preferences.userRoot().node("dig").node("fsm");
    private static final String PREF_FOLDER = "folder";
    private static final Icon ICON_NEW = IconCreator.create("document-new.png");
    private static final Icon ICON_OPEN = IconCreator.create("document-open.png");
    private static final Icon ICON_SAVE = IconCreator.create("document-save.png");
    private static final Icon ICON_SAVE_AS = IconCreator.create("document-save-as.png");
    private static final Icon ICON_EXPAND = IconCreator.create("View-zoom-fit.png");
    private static final Icon ICON_ZOOM_IN = IconCreator.create("View-zoom-in.png");
    private static final Icon ICON_ZOOM_OUT = IconCreator.create("View-zoom-out.png");
    private static final Icon ICON_HELP = IconCreator.create("help.png");
    private final FileHistory fileHistory;
    private final FSMComponent fsmComponent;
    private final Timer timer;
    private final JComboBox<String> moveControl;
    private FSM fsm;
    private ToolTipAction save;
    private File filename;
    private File baseFilename;
    private boolean lastModified;
    private String probeLabelName;
    private final GlobalValues.GlobalValueListener stateListener = new StateListener();

    public static void openFile(File file) {
        ElementLibrary library = new ElementLibrary();
        new ShapeFactory(library);
        SwingUtilities.invokeLater(() -> new FSMFrame(null, library, file).setVisible(true));
    }

    public FSMFrame(JFrame parent, ElementLibrary library) {
        this(parent, library, null);
    }

    public FSMFrame(JFrame parent, ElementLibrary library, File filename) {
        super(Lang.get("fsm_title", new Object[0]));
        this.setDefaultCloseOperation(0);
        this.setIconImages(IconCreator.createImages("icon32.png", "icon64.png", "icon128.png"));
        this.fileHistory = new FileHistory(this, PREFS.node("hist"));
        this.fsmComponent = new FSMComponent();
        this.getContentPane().add((Component)this.fsmComponent, "Center");
        this.timer = new Timer(100, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (FSMFrame.this.fsm.getMovingState() == FSM.MovingState.STOP) {
                    FSMFrame.this.timer.stop();
                } else {
                    int i = 0;
                    while (i < 100) {
                        FSMFrame.this.fsm.move(10, FSMFrame.this.fsmComponent.getElementMoved());
                        ++i;
                    }
                    FSMFrame.this.repaint();
                }
            }
        });
        GlobalValues.getInstance().addListener(this.stateListener);
        this.addWindowListener(new ClosingWindowListener(this, this));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                FSMFrame.this.timer.stop();
                GlobalValues.getInstance().removeListener(FSMFrame.this.stateListener);
            }
        });
        JMenuBar bar = new JMenuBar();
        JToolBar toolBar = new JToolBar();
        this.createFileMenu(bar, toolBar);
        toolBar.addSeparator();
        this.createViewMenu(bar, toolBar);
        toolBar.addSeparator();
        this.createCreateMenu(bar, library);
        bar.add(WindowManager.getInstance().registerAndCreateMenu(this));
        this.createHelpMenu(bar, toolBar);
        toolBar.addSeparator();
        this.moveControl = new JComboBox<String>(new String[]{Lang.get("fsm_noMove", new Object[0]), Lang.get("fsm_moveTrans", new Object[0]), Lang.get("fsm_moveStates", new Object[0])});
        this.moveControl.setSelectedIndex(0);
        this.moveControl.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                switch (FSMFrame.this.moveControl.getSelectedIndex()) {
                    case 0: {
                        FSMFrame.this.fsm.setMovingState(FSM.MovingState.STOP);
                        FSMFrame.this.fsmComponent.repaint();
                        break;
                    }
                    case 1: {
                        FSMFrame.this.fsm.setMovingState(FSM.MovingState.TRANSITIONS);
                        FSMFrame.this.timer.start();
                        break;
                    }
                    case 2: {
                        FSMFrame.this.fsm.setMovingState(FSM.MovingState.BOTH);
                        FSMFrame.this.timer.start();
                    }
                }
            }
        });
        JPanel movePanel = new JPanel(new BorderLayout());
        movePanel.add(this.moveControl, "West");
        toolBar.add(movePanel);
        this.getContentPane().add((Component)toolBar, "First");
        this.setJMenuBar(bar);
        this.pack();
        new WindowSizeStorage("fsm").setDefaultSize(600, 600).restore(this);
        this.setFSM(new FSM(new State[0]));
        SwingUtilities.invokeLater(() -> {
            if (filename != null) {
                this.loadFile(filename);
            } else {
                File f = new FileLocator(this.probeLabelName).setBaseFile(this.baseFilename).setHistory(this.fileHistory).setLibrary(library).locate();
                if (f != null) {
                    this.loadFile(f);
                }
            }
        });
        this.setLocationRelativeTo(parent);
    }

    private void createFileMenu(JMenuBar bar, JToolBar toolBar) {
        ToolTipAction newFile = new ToolTipAction(Lang.get("menu_new", new Object[0]), ICON_NEW){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ClosingWindowListener.checkForSave(FSMFrame.this, FSMFrame.this)) {
                    FSMFrame.this.setFSM(new FSM(new State[0]));
                    FSMFrame.this.setFilename(null);
                }
            }
        }.setAcceleratorCTRLplus('N').setToolTip(Lang.get("menu_new_tt", new Object[0]));
        ToolTipAction open = new ToolTipAction(Lang.get("menu_open", new Object[0]), ICON_OPEN){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc;
                if (ClosingWindowListener.checkForSave(FSMFrame.this, FSMFrame.this) && (fc = FSMFrame.this.getJFileChooser(FSMFrame.this.filename)).showOpenDialog(FSMFrame.this) == 0) {
                    FSMFrame.this.loadFile(SaveAsHelper.checkSuffix(fc.getSelectedFile(), "fsm"));
                }
            }
        }.setAcceleratorCTRLplus('O');
        JMenu openRecent = new JMenu(Lang.get("menu_openRecent", new Object[0]));
        this.fileHistory.setMenu(openRecent, null);
        final ToolTipAction saveAs = new ToolTipAction(Lang.get("menu_saveAs", new Object[0]), ICON_SAVE_AS){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = FSMFrame.this.getJFileChooser(FSMFrame.this.filename);
                SaveAsHelper saveAsHelper = new SaveAsHelper(FSMFrame.this, fc, "fsm");
                saveAsHelper.checkOverwrite(file -> FSMFrame.this.saveFile(file));
            }
        };
        this.save = new ToolTipAction(Lang.get("menu_save", new Object[0]), ICON_SAVE){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FSMFrame.this.filename == null) {
                    saveAs.actionPerformed(e);
                } else {
                    FSMFrame.this.saveFile(FSMFrame.this.filename);
                }
            }
        }.setAcceleratorCTRLplus('S').setEnabledChain(false);
        JMenu export = new JMenu(Lang.get("menu_export", new Object[0]));
        export.add(new ExportAction(Lang.get("menu_exportSVG", new Object[0]), "svg", GraphicSVG::new));
        JMenu file = new JMenu(Lang.get("menu_file", new Object[0]));
        bar.add(file);
        file.add(newFile.createJMenuItem());
        file.add(open.createJMenuItem());
        file.add(openRecent);
        file.add(this.save.createJMenuItem());
        file.add(saveAs.createJMenuItem());
        file.add(export);
        toolBar.add(newFile.createJButtonNoText());
        toolBar.add(open.createJButtonNoText());
        toolBar.add(this.save.createJButtonNoText());
    }

    private void setFSM(FSM fsm) {
        this.fsm = fsm;
        this.fsmComponent.setFSM(fsm);
        fsm.setModifiedListener(this);
    }

    private JFileChooser getJFileChooser(File filename) {
        String folderStr;
        File folder = null;
        if (filename != null) {
            folder = filename.getParentFile();
        }
        if (folder == null && this.baseFilename != null) {
            folder = this.baseFilename.getParentFile();
        }
        if (folder == null && (folderStr = PREFS.get(PREF_FOLDER, null)) != null) {
            folder = new File(folderStr);
        }
        MyFileChooser fileChooser = new MyFileChooser(folder);
        fileChooser.setFileFilter(new FileNameExtensionFilter("FSM", "fsm"));
        return fileChooser;
    }

    private void setFilename(File filename) {
        String fsmTitle = filename == null ? Lang.get("fsm_title", new Object[0]) : String.valueOf(filename.toString()) + " - " + Lang.get("fsm_title", new Object[0]);
        if (this.fsm.isModified()) {
            fsmTitle = "*" + fsmTitle;
        }
        this.setTitle(fsmTitle);
        this.filename = filename;
        if (filename != null) {
            this.fileHistory.add(filename);
        }
    }

    @Override
    public boolean isStateChanged() {
        return this.fsm.isModified();
    }

    @Override
    public void saveChanges() {
        this.save.actionPerformed(null);
    }

    @Override
    public void modifiedChanged(boolean modified) {
        if (this.lastModified != modified) {
            this.lastModified = modified;
            this.setFilename(this.filename);
            this.save.setEnabled(modified);
        }
    }

    public void loadFile(File file) {
        try {
            this.moveControl.setSelectedIndex(0);
            this.setFSM(FSM.loadFSM(file));
            this.setFilename(file);
            this.lastModified = this.fsm.isModified();
            PREFS.put(PREF_FOLDER, file.getParent());
        }
        catch (IOException e) {
            new ErrorMessage(Lang.get("msg_fsm_errorLoadingFile", new Object[0])).addCause(e).show(this);
        }
    }

    private void saveFile(File file) {
        try {
            this.moveControl.setSelectedIndex(0);
            this.fsm.save(file);
            this.setFilename(file);
            this.save.setEnabled(false);
            this.lastModified = this.fsm.isModified();
            PREFS.put(PREF_FOLDER, file.getParent());
        }
        catch (IOException e) {
            new ErrorMessage(Lang.get("msg_fsm_errorStoringFile", new Object[0])).addCause(e).show(this);
        }
    }

    @Override
    public void open(File file, boolean newWindow) {
        if (ClosingWindowListener.checkForSave(this, this)) {
            this.loadFile(file);
        }
    }

    private void createViewMenu(JMenuBar menuBar, JToolBar toolBar) {
        ToolTipAction maximize = new ToolTipAction(Lang.get("menu_maximize", new Object[0]), ICON_EXPAND){

            @Override
            public void actionPerformed(ActionEvent e) {
                FSMFrame.this.fsmComponent.fitFSM();
            }
        }.setAccelerator("F1");
        ToolTipAction zoomIn = new ToolTipAction(Lang.get("menu_zoomIn", new Object[0]), ICON_ZOOM_IN){

            @Override
            public void actionPerformed(ActionEvent e) {
                FSMFrame.this.fsmComponent.scaleCircuit(1.1111111111111112);
            }
        }.setAcceleratorCTRLplus("PLUS");
        this.fsmComponent.getInputMap().put(KeyStroke.getKeyStroke(61, 128, false), zoomIn);
        this.fsmComponent.getInputMap().put(KeyStroke.getKeyStroke(107, 128, false), zoomIn);
        this.fsmComponent.getActionMap().put(zoomIn, zoomIn);
        ToolTipAction zoomOut = new ToolTipAction(Lang.get("menu_zoomOut", new Object[0]), ICON_ZOOM_OUT){

            @Override
            public void actionPerformed(ActionEvent e) {
                FSMFrame.this.fsmComponent.scaleCircuit(0.9);
            }
        }.setAcceleratorCTRLplus("MINUS");
        this.fsmComponent.getInputMap().put(KeyStroke.getKeyStroke(109, 128, false), zoomOut);
        this.fsmComponent.getActionMap().put(zoomOut, zoomOut);
        toolBar.add(zoomIn.createJButtonNoText());
        toolBar.add(zoomOut.createJButtonNoText());
        toolBar.add(maximize.createJButtonNoText());
        JMenu view = new JMenu(Lang.get("menu_view", new Object[0]));
        menuBar.add(view);
        view.add(maximize.createJMenuItem());
        view.add(zoomOut.createJMenuItem());
        view.add(zoomIn.createJMenuItem());
    }

    private void createCreateMenu(JMenuBar bar, final ElementLibrary library) {
        int[] counterValues;
        JMenu create = new JMenu(Lang.get("menu_fsm_create", new Object[0]));
        bar.add(create);
        create.add(new ToolTipAction(Lang.get("menu_fsm_create_table", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    new TableDialog((Window)FSMFrame.this, FSMFrame.this.fsm.createTruthTable(FSMFrame.this.getStateSignalName()), library, FSMFrame.this.filename).setVisible(true);
                }
                catch (Exception e) {
                    new ErrorMessage(Lang.get("msg_fsmCantCreateTable", new Object[0])).addCause(e).show(FSMFrame.this);
                }
            }
        }.createJMenuItem());
        JMenu counter = new JMenu(Lang.get("menu_fsm_create_counter", new Object[0]));
        create.add(counter);
        int[] nArray = counterValues = new int[]{4, 5, 6, 7, 8, 10, 16};
        int n = counterValues.length;
        int n2 = 0;
        while (n2 < n) {
            final int n3 = nArray[n2];
            counter.add(new ToolTipAction(Lang.get("menu_fsm_create_counter_N", n3)){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ClosingWindowListener.checkForSave(FSMFrame.this, FSMFrame.this)) {
                        FSMFrame.this.setFSM(FSMDemos.counter(n3).circle().setModified(false));
                        FSMFrame.this.setFilename(null);
                    }
                }
            });
            ++n2;
        }
        if (Main.isExperimentalMode()) {
            create.add(new ToolTipAction(Lang.get("menu_fsm_oneBitPerState", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    List<State> states = FSMFrame.this.fsm.getStates();
                    if (states.size() < 32) {
                        int mask = 1;
                        for (State s : states) {
                            s.setNumber(mask);
                            mask *= 2;
                        }
                        FSMFrame.this.fsmComponent.repaint();
                    }
                }
            }.setToolTip(Lang.get("menu_fsm_oneBitPerState_tt", new Object[0])).createJMenuItem());
            create.add(new ToolTipAction(Lang.get("menu_fsm_optimize_state_numbers", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        try {
                            new OptimizerDialog(FSMFrame.this).setVisible(true);
                        }
                        catch (ExpressionException | FormatterException | FiniteStateMachineException e) {
                            new ErrorMessage(Lang.get("menu_fsm_optimize_state_numbers_err", new Object[0])).addCause(e).show(FSMFrame.this);
                            FSMFrame.this.fsmComponent.repaint();
                        }
                    }
                    finally {
                        FSMFrame.this.fsmComponent.repaint();
                    }
                }
            }.setToolTip(Lang.get("menu_fsm_optimize_state_numbers_tt", new Object[0])).createJMenuItem());
        }
    }

    public FSMFrame setBaseFileName(File filename) {
        this.baseFilename = filename;
        return this;
    }

    public FSMFrame setProbeLabelName(String probeLabelName) {
        this.probeLabelName = probeLabelName;
        return this;
    }

    private void createHelpMenu(JMenuBar bar, JToolBar toolBar) {
        JMenu helpMenu = new JMenu(Lang.get("menu_help", new Object[0]));
        ToolTipAction viewHelp = new ToolTipAction(Lang.get("menu_help", new Object[0]), ICON_HELP){

            @Override
            public void actionPerformed(ActionEvent e) {
                new ShowStringDialog((Window)FSMFrame.this, Lang.get("msg_fsmHelpTitle", new Object[0]), Lang.get("msg_fsmHelp", new Object[0]), true).setVisible(true);
            }
        }.setToolTip(Lang.get("menu_fsm_Help_tt", new Object[0]));
        helpMenu.add(viewHelp.createJMenuItem());
        helpMenu.add(InfoDialog.getInstance().createMenuItem(this, Lang.get("message", new Object[0])));
        bar.add(helpMenu);
        toolBar.add(viewHelp);
    }

    private String getStateSignalName() {
        if (this.filename != null) {
            return this.filename.getName();
        }
        return "state";
    }

    private void setActiveState(long value) {
        if (this.fsm.setActiveStateTransition((int)value)) {
            SwingUtilities.invokeLater(this.fsmComponent::repaint);
        }
    }

    public FSM getFSM() {
        return this.fsm;
    }

    public static void main(String[] args) {
        ElementLibrary library = new ElementLibrary();
        new ShapeFactory(library);
        File f = null;
        if (args.length == 1) {
            f = new File(args[0]);
        }
        new FSMFrame(null, library, f).setVisible(true);
    }

    private class ExportAction
    extends ToolTipAction {
        private final String name;
        private final String suffix;
        private final ExportFactory exportFactory;

        ExportAction(String name, String suffix, ExportFactory exportFactory) {
            super(name);
            this.name = name;
            this.suffix = suffix;
            this.exportFactory = exportFactory;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ElementAttributes settings;
            File exportDir;
            MyFileChooser fc = new MyFileChooser();
            if (FSMFrame.this.filename != null) {
                fc.setSelectedFile(SaveAsHelper.checkSuffix(FSMFrame.this.filename, this.suffix));
            }
            if ((exportDir = (settings = Settings.getInstance().getAttributes()).getFile("exportDirectory")) != null) {
                fc.setCurrentDirectory(exportDir);
            }
            fc.addChoosableFileFilter(new FileNameExtensionFilter(this.name, this.suffix));
            new SaveAsHelper(FSMFrame.this, fc, this.suffix).checkOverwrite(file -> {
                settings.setFile("exportDirectory", file.getParentFile());
                Throwable throwable = null;
                Object var4_5 = null;
                try (FileOutputStream out = new FileOutputStream(file);){
                    Throwable throwable2 = null;
                    Object var7_10 = null;
                    try (Graphic gr = this.exportFactory.create(out);){
                        GraphicMinMax minMax = new GraphicMinMax(gr);
                        FSMFrame.this.fsm.drawTo(minMax);
                        gr.setBoundingBox(minMax.getMin(), minMax.getMax());
                        FSMFrame.this.fsm.drawTo(gr);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            });
        }
    }

    private class StateListener
    implements GlobalValues.GlobalValueListener {
        private StateListener() {
        }

        @Override
        public void valueCreated(String name, ObservableValue value, Model model) {
            if (name.equals(FSMFrame.this.getStateSignalName())) {
                value.addObserverToValue(() -> FSMFrame.this.setActiveState(value.getValue()));
                FSMFrame.this.setActiveState(value.getValue());
                model.addObserver(event -> {
                    if (event == ModelEvent.CLOSED) {
                        FSMFrame.this.setActiveState(-1L);
                    }
                }, ModelEventType.CLOSED, new ModelEventType[0]);
            }
        }
    }
}

