/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui;

import de.neemann.gui.InfoDialog;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigitalUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DigitalUncaughtExceptionHandler.class);
    private final DateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        throwable.printStackTrace();
        File home = new File(System.getProperty("user.home"));
        File log = new File(home, "Digital_" + this.formatDate.format(new Date()) + ".log");
        LOGGER.info("uncaught exception log written to " + log);
        try {
            Throwable throwable2 = null;
            Object var6_8 = null;
            try (BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(log), StandardCharsets.UTF_8));){
                this.writeLog(w, thread, throwable);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeLog(BufferedWriter w, Thread thread, Throwable throwable) throws IOException {
        w.write("This file was created because there was an unexpected exception in Digital.");
        w.newLine();
        w.write("Please send this file to digital-simulator@web.de or create an issue at");
        w.newLine();
        w.write("GitHub: https://github.com/hneemann/Digital/issues");
        w.newLine();
        w.newLine();
        w.write("Manifest: ");
        w.newLine();
        for (InfoDialog.Manifest m : InfoDialog.getInstance()) {
            this.writeManifest(w, m);
        }
        w.newLine();
        w.write("System properties:");
        w.newLine();
        this.writeProperties(w, "java.");
        w.newLine();
        this.writeProperties(w, "os.");
        w.newLine();
        w.write("thread: ");
        w.write(thread.getName());
        w.newLine();
        w.newLine();
        w.write("exception: ");
        w.newLine();
        throwable.printStackTrace(new PrintWriter(w));
    }

    private void writeManifest(BufferedWriter w, InfoDialog.Manifest m) throws IOException {
        String path = m.getUrl().getPath();
        int p = path.lastIndexOf("!/");
        if (p >= 0 && (p = (path = path.substring(0, p)).lastIndexOf(47)) >= 0) {
            w.write(path.substring(p + 1));
            w.write(":");
            w.newLine();
        }
        for (Map.Entry<String, String> a : m.getEntries().entrySet()) {
            w.write(a.getKey());
            w.write("=");
            w.write(a.getValue());
            w.newLine();
        }
    }

    private void writeProperties(BufferedWriter w, String suffix) throws IOException {
        Enumeration<?> names = System.getProperties().propertyNames();
        while (names.hasMoreElements()) {
            String n = names.nextElement().toString();
            if (!n.startsWith(suffix)) continue;
            w.write(n);
            w.write("=");
            w.write(System.getProperty(n));
            w.newLine();
        }
    }
}

