/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui;

import de.neemann.digital.lang.Lang;
import de.neemann.gui.ErrorMessage;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public final class SaveAsHelper {
    private static final HashSet<String> KNOWN = new HashSet();
    private final Component parent;
    private final JFileChooser fc;
    private final String suffix;
    private boolean repeat;

    static {
        KNOWN.add("dig");
        KNOWN.add("fsm");
        KNOWN.add("hex");
        KNOWN.add("tru");
        KNOWN.add("svg");
        KNOWN.add("vhdl");
        KNOWN.add("v");
        KNOWN.add("csv");
        KNOWN.add("gif");
        KNOWN.add("png");
        KNOWN.add("tt2");
        KNOWN.add("cupl");
        KNOWN.add("jed");
        KNOWN.add("zip");
    }

    public SaveAsHelper(Component parent, JFileChooser fc) {
        this(parent, fc, null);
    }

    public SaveAsHelper(Component parent, JFileChooser fc, String suffix) {
        this.parent = parent;
        this.fc = fc;
        this.suffix = suffix;
    }

    public void checkOverwrite(SaveAs saveAs) {
        do {
            this.repeat = false;
            if (this.fc.showSaveDialog(this.parent) != 0) continue;
            File selectedFile = SaveAsHelper.checkSuffix(this.fc.getSelectedFile(), this.suffix);
            if (selectedFile.exists()) {
                Object[] options = new Object[]{Lang.get("btn_overwrite", new Object[0]), Lang.get("btn_newName", new Object[0])};
                int res = JOptionPane.showOptionDialog(this.parent, Lang.get("msg_fileExists", selectedFile.getName()), Lang.get("msg_warning", new Object[0]), -1, 2, null, options, options[0]);
                if (res != 0) {
                    this.repeat = true;
                    continue;
                }
            }
            try {
                saveAs.saveAs(selectedFile);
            }
            catch (IOException e) {
                new ErrorMessage(Lang.get("msg_errorWritingFile", new Object[0])).addCause(e).show(this.parent);
            }
        } while (this.repeat);
    }

    public void retryFileSelect() {
        this.repeat = true;
    }

    public static File checkSuffix(File filename, String suffix) {
        if (suffix == null || filename == null) {
            return filename;
        }
        String name = filename.getName();
        int p = name.lastIndexOf(46);
        if (p >= 0) {
            String suf = name.substring(p + 1).toLowerCase();
            if (KNOWN.contains(suf)) {
                name = name.substring(0, p);
            }
            while (name.length() > 0 && name.charAt(name.length() - 1) == '.') {
                name = name.substring(0, name.length() - 1);
            }
        }
        return new File(filename.getParentFile(), String.valueOf(name) + "." + suffix);
    }

    public static interface SaveAs {
        public void saveAs(File var1) throws IOException;
    }
}

