/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.Signal;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.draw.elements.VisualElement;
import de.neemann.digital.draw.shapes.ShapeFactory;
import de.neemann.digital.gui.Main;
import de.neemann.digital.gui.ModelModifier;
import de.neemann.digital.lang.Lang;
import de.neemann.digital.testing.TestCaseDescription;
import de.neemann.digital.testing.TestCaseElement;
import de.neemann.digital.testing.parser.ParserException;
import de.neemann.gui.ErrorMessage;
import de.neemann.gui.Screen;
import de.neemann.gui.ToolTipAction;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class BehavioralFixtureCreator
extends JDialog
implements ModelModifier {
    private final JLabel frameLabel;
    private final Main main;
    private final ShapeFactory shapeFactory;
    private final StringBuilder testCase;
    private int testLines;
    private Model model;

    public BehavioralFixtureCreator(Main parent, ShapeFactory shapeFactory) {
        super(parent, Lang.get("menu_createBehavioralFixture", new Object[0]), false);
        this.main = parent;
        this.shapeFactory = shapeFactory;
        this.setDefaultCloseOperation(2);
        this.frameLabel = new JLabel(Lang.get("msg_fixesCreated_N", this.testLines));
        this.frameLabel.setFont(Screen.getInstance().getFont(1.5f));
        this.frameLabel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add(this.frameLabel);
        GridLayout layout = new GridLayout(2, 1);
        layout.setVgap(5);
        JPanel buttons = new JPanel(layout);
        buttons.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        buttons.add(new ToolTipAction(Lang.get("btn_createTestLine", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BehavioralFixtureCreator.this.addFixture();
            }
        }.setToolTip(Lang.get("btn_createTestLine_tt", new Object[0])).createJButton());
        buttons.add(new ToolTipAction(Lang.get("btn_BehavioralFixtureComplete", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BehavioralFixtureCreator.this.createTestCase();
            }
        }.setToolTip(Lang.get("btn_BehavioralFixtureComplete_tt", new Object[0])).createJButton());
        this.getContentPane().add((Component)buttons, "South");
        this.testCase = new StringBuilder();
        this.pack();
        this.setLocation(parent.getLocation());
    }

    private void addFixture() {
        if (this.testCase.length() == 0) {
            for (Signal s : this.model.getInputs()) {
                if (this.testCase.length() > 0) {
                    this.testCase.append(' ');
                }
                this.testCase.append(s.getName());
            }
            for (Signal s : this.model.getOutputs()) {
                this.testCase.append(" ").append(s.getName());
            }
            this.testCase.append('\n');
        }
        boolean first = true;
        for (Signal s : this.model.getInputs()) {
            if (first) {
                first = false;
            } else {
                this.testCase.append(' ');
            }
            this.addValue(this.testCase, s);
        }
        for (Signal s : this.model.getOutputs()) {
            this.testCase.append(' ');
            this.addValue(this.testCase, s);
        }
        this.testCase.append('\n');
        ++this.testLines;
        this.frameLabel.setText(Lang.get("msg_fixesCreated_N", this.testLines));
    }

    private void addValue(StringBuilder testCase, Signal s) {
        ObservableValue value = s.getValue();
        if (value.isHighZ()) {
            testCase.append('Z');
        } else {
            int bits = value.getBits();
            if (bits <= 3) {
                testCase.append(value.getValue());
            } else {
                testCase.append("0x").append(Long.toHexString(value.getValue()));
            }
        }
    }

    private void createTestCase() {
        this.dispose();
        try {
            VisualElement tc = new VisualElement(TestCaseElement.DESCRIPTION.getName()).setShapeFactory(this.shapeFactory).setAttribute(Keys.TESTDATA, new TestCaseDescription(this.testCase.toString()));
            SwingUtilities.invokeLater(() -> this.main.getCircuitComponent().setPartToInsert(tc));
        }
        catch (ParserException | IOException e) {
            SwingUtilities.invokeLater(new ErrorMessage(Lang.get("msg_errorCreatingTestCase", new Object[0])).addCause(e));
        }
    }

    @Override
    public void preInit(Model model) throws NodeException {
        this.model = model;
        if (model.getInputs().isEmpty()) {
            throw new NodeException(Lang.get("err_analyseNoInputs", new Object[0]), new ObservableValue[0]);
        }
        if (model.getOutputs().isEmpty()) {
            throw new NodeException(Lang.get("err_analyseNoOutputs", new Object[0]), new ObservableValue[0]);
        }
        SwingUtilities.invokeLater(() -> this.setVisible(true));
    }
}

